/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.events.PlayerPrizeEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.badbones69.crazycrates.paper.utils.MsgUtils;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrizeManager {
    private static final CrazyCrates plugin = CrazyCrates.getPlugin();
    private static final Server server = plugin.getServer();
    private static final PluginManager pluginManager = server.getPluginManager();
    private static final ComponentLogger logger = plugin.getComponentLogger();
    private static final BukkitUserManager userManager = plugin.getUserManager();
    private static final SettingsManager config = ConfigManager.getConfig();

    public static int getCap(@NotNull Crate crate, @NotNull Player player) {
        String format = "crazycrates.respin." + crate.getFileName() + ".";
        String lowerCase = format.toLowerCase();
        int cap = 0;
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            int number;
            String node = permission.getPermission();
            if (!node.startsWith(lowerCase) || (number = Integer.parseInt(node = node.replace(lowerCase, ""))) <= cap || cap >= crate.getCyclePermissionCap()) continue;
            cap = number;
        }
        return cap;
    }

    public static boolean isCapped(@NotNull Crate crate, @NotNull Player player) {
        boolean isCapped = false;
        if (!crate.isCyclePermissionToggle() || crate.getCyclePermissionCap() < 1 || player.isOp()) {
            return false;
        }
        int wins = userManager.getCrateRespin(player.getUniqueId(), crate.getFileName());
        int cap = PrizeManager.getCap(crate, player);
        String format = "crazycrates.respin." + crate.getFileName() + ".";
        String node = format + cap;
        if (player.hasPermission(node)) {
            if (wins >= cap) {
                isCapped = true;
            }
        } else {
            isCapped = true;
        }
        return isCapped;
    }

    @Deprecated(forRemoval=true, since="4.2.1")
    public static void givePrize(@NotNull Player player, @Nullable Prize prize, @NotNull Crate crate) {
        PrizeManager.givePrize(player, crate, prize);
    }

    public static void givePrize(@NotNull Player player, final @NotNull Crate crate, @Nullable Prize prize) {
        if (prize != null) {
            PrizeManager.givePrize(player, player.getLocation().clone().add(0.0, 1.0, 0.0), crate, prize);
        } else {
            Messages.prize_error.sendMessage((CommandSender)player, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("{crate}", crate.getCrateName());
                }
            });
        }
    }

    public static void givePrize(@NotNull Player player, @NotNull Location location, @NotNull Crate crate, @Nullable Prize prize) {
        int pulls;
        if (prize == null) {
            if (MiscUtils.isLogging()) {
                logger.warn("No prize was found when giving {} a prize.", (Object)player.getName());
            }
            return;
        }
        pluginManager.callEvent((Event)new PlayerPrizeEvent(player, crate, prize));
        if (prize.useFireworks()) {
            MiscUtils.spawnFirework(location, null);
        }
        Prize prize2 = prize = prize.hasPermission(player) ? prize.getAlternativePrize() : prize;
        if (!player.isOp() && (pulls = PrizeManager.getCurrentPulls(prize, crate)) != -1 && pulls < prize.getMaxPulls()) {
            YamlConfiguration configuration = FileKeys.data.getConfiguration();
            configuration.set("Prizes." + crate.getFileName() + "." + prize.getSectionName() + ".Pulls", (Object)(pulls + 1));
            FileKeys.data.save();
        }
        MiscUtils.dropItems(prize.getEditorItems(), player);
        if (config.getProperty(ConfigKeys.use_different_items_layout).booleanValue()) {
            MiscUtils.dropBuilders(prize.getItems(), player);
        } else {
            MiscUtils.dropLegacyBuilders(prize.getItemBuilders(), player);
        }
        for (String command : crate.getPrizeCommands()) {
            PrizeManager.runCommands(player, prize, crate, command);
        }
        for (String command : prize.getCommands()) {
            PrizeManager.runCommands(player, prize, crate, command);
        }
        prize.broadcast(player, crate);
        List<String> cratePrizeMessages = crate.getPrizeMessage();
        List<String> prizeMessages = prize.getMessages();
        if (!cratePrizeMessages.isEmpty() && prizeMessages.isEmpty()) {
            for (String message : cratePrizeMessages) {
                PrizeManager.sendMessage(player, prize, crate, message);
            }
            return;
        }
        for (String message : prizeMessages) {
            PrizeManager.sendMessage(player, prize, crate, message);
        }
    }

    private static void runCommands(@NotNull Player player, @NotNull Prize prize, @NotNull Crate crate, @NotNull String command) {
        String cmd = command;
        if (cmd.contains("%random%:")) {
            StringBuilder commandBuilder = new StringBuilder();
            for (String word : cmd.split(" ")) {
                if (word.startsWith("%random%:")) {
                    word = word.replace("%random%:", "");
                    try {
                        long min = Long.parseLong(word.split("-")[0]);
                        long max = Long.parseLong(word.split("-")[1]);
                        commandBuilder.append(MiscUtils.pickNumber(min, max)).append(" ");
                    }
                    catch (Exception exception) {
                        commandBuilder.append("1 ");
                        if (!MiscUtils.isLogging()) continue;
                        logger.warn("The prize {} in the {} crate has caused an error when trying to run a command.", (Object)prize.getPrizeName(), (Object)prize.getCrateName());
                        logger.warn("Command: {}", (Object)cmd);
                    }
                    continue;
                }
                commandBuilder.append(word).append(" ");
            }
            cmd = commandBuilder.toString();
            cmd = cmd.substring(0, cmd.length() - 1);
        }
        if (Plugins.placeholder_api.isEnabled()) {
            cmd = PlaceholderAPI.setPlaceholders((Player)player, (String)cmd);
        }
        String maxPulls = String.valueOf(prize.getMaxPulls());
        String pulls = String.valueOf(PrizeManager.getCurrentPulls(prize, crate));
        String prizeName = prize.getPrizeName().replaceAll("%maxpulls%", maxPulls).replaceAll("%pulls%", pulls);
        MiscUtils.sendCommand(cmd.replaceAll("%player%", Matcher.quoteReplacement(player.getName())).replaceAll("%reward%", Matcher.quoteReplacement(prizeName)).replaceAll("%reward_stripped%", Matcher.quoteReplacement(prize.getStrippedName())).replaceAll("%crate_fancy%", Matcher.quoteReplacement(crate.getCrateName())).replaceAll("%crate%", Matcher.quoteReplacement(crate.getFileName())).replaceAll("%maxpulls%", maxPulls).replaceAll("%pulls%", pulls));
    }

    private static void sendMessage(@NotNull Player player, @NotNull Prize prize, @NotNull Crate crate, @NotNull String message) {
        if (message.isEmpty()) {
            return;
        }
        String maxPulls = String.valueOf(prize.getMaxPulls());
        String pulls = String.valueOf(PrizeManager.getCurrentPulls(prize, crate));
        String prizeName = prize.getPrizeName().replaceAll("%maxpulls%", maxPulls).replaceAll("%pulls%", pulls);
        String defaultMessage = message.replaceAll("%player%", Matcher.quoteReplacement(player.getName())).replaceAll("%reward%", Matcher.quoteReplacement(prizeName)).replaceAll("%reward_stripped%", Matcher.quoteReplacement(prize.getStrippedName())).replaceAll("%crate%", Matcher.quoteReplacement(crate.getCrateName())).replaceAll("%maxpulls%", maxPulls).replaceAll("%pulls%", pulls).replaceAll("%chance%", StringUtils.format(crate.getChance(prize.getWeight()))).replaceAll("%weight%", String.valueOf(prize.getWeight()));
        MsgUtils.sendMessage((CommandSender)player, Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)defaultMessage) : defaultMessage, false);
    }

    public static int getCurrentPulls(Prize prize, Crate crate) {
        if (prize.getMaxPulls() == -1) {
            return 0;
        }
        YamlConfiguration configuration = FileKeys.data.getConfiguration();
        ConfigurationSection section = configuration.getConfigurationSection("Prizes." + crate.getFileName() + "." + prize.getSectionName());
        if (section == null) {
            return 0;
        }
        return section.getInt("Pulls", 0);
    }

    public static void getPrize(@NotNull Crate crate, @NotNull Inventory inventory, int slot, @NotNull Player player) {
        ItemStack item = inventory.getItem(slot);
        if (item == null) {
            return;
        }
        PrizeManager.givePrize(player, player.getLocation().clone().add(0.0, 1.0, 0.0), crate, crate.getPrize(item));
    }

    @Nullable
    public static Tier getTier(@NotNull Crate crate) {
        int index;
        List<Tier> tiers = crate.getTiers();
        if (tiers.isEmpty()) {
            return null;
        }
        Random random = MiscUtils.getRandom();
        double weight = 0.0;
        for (Tier tier : tiers) {
            weight += tier.getWeight();
        }
        double value = random.nextDouble() * weight;
        for (index = 0; index < tiers.size() - 1 && !((value -= tiers.get(index).getWeight()) <= 0.0); ++index) {
        }
        return tiers.get(index);
    }
}

