/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.builders;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBuilder
implements InventoryHolder,
Listener {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final ComponentLogger logger = this.plugin.getComponentLogger();
    protected final Server server = this.plugin.getServer();
    private Inventory inventory;
    private Player player;
    private String title;
    private Crate crate;
    private int size;
    private int page;
    private List<Tier> tiers;

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size) {
        this.player = player;
        this.title = title;
        this.size = size;
        String inventoryTitle = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtils.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, @NotNull Crate crate) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.crate = crate;
        String inventoryTitle = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtils.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, int page, @NotNull Crate crate) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.page = page;
        this.crate = crate;
        String inventoryTitle = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtils.parse(inventoryTitle));
    }

    public InventoryBuilder(@NotNull Player player, @NotNull String title, int size, @NotNull Crate crate, @NotNull List<Tier> tiers) {
        this.player = player;
        this.title = title;
        this.size = size;
        this.crate = crate;
        this.tiers = tiers;
        String inventoryTitle = Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)this.getPlayer(), (String)this.title) : this.title;
        this.inventory = this.server.createInventory((InventoryHolder)this, this.size, AdvUtils.parse(inventoryTitle));
    }

    public InventoryBuilder() {
    }

    public abstract InventoryBuilder build();

    public abstract void run(InventoryClickEvent var1);

    @EventHandler
    public void onPlayerClick(InventoryClickEvent event) {
        this.run(event);
    }

    public void size(int size) {
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSize(boolean isBorderEnabled) {
        return this.size - (isBorderEnabled ? 18 : (this.size != 9 ? 9 : 0));
    }

    public void setPage(int page) {
        this.page = page;
    }

    public final int getPage() {
        return this.page;
    }

    @NotNull
    public final Crate getCrate() {
        return this.crate;
    }

    public void title(@NotNull String title) {
        this.title = title;
    }

    public final boolean contains(@NotNull String message) {
        return this.title.contains(message);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final List<Tier> getTiers() {
        return this.tiers;
    }

    @NotNull
    public final InventoryView getView() {
        return this.getPlayer().getOpenInventory();
    }

    public void sendTitleChange() {
        ColorUtils.updateTitle(this.player, this.title);
    }

    @NotNull
    public final Inventory getInventory() {
        return this.inventory;
    }
}

