/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class CommandDebug
extends BaseCommand {
    @Command(value="debug")
    @Permission(value={"crazycrates.debug"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates <crate> [player_name]")
    public void debug(CommandSender sender, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @Optional @Suggestion(value="players") Player target) {
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage(sender, "{value}", "crate name");
            return;
        }
        Crate crate = this.crateManager.getCrateFromName(crateName);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        List<Prize> prizes = crate.getPrizes();
        List<Prize> items = prizes.stream().filter(Prize::isItemsEmpty).toList();
        if (prizes.isEmpty() || items.isEmpty()) {
            Messages.no_prizes_found.sendMessage(sender, "{crate}", crateName);
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (target == null) {
                prizes.forEach(prize -> PrizeManager.givePrize(player, crate, prize));
                return;
            }
        }
        prizes.forEach(prize -> PrizeManager.givePrize(target, crate, prize));
    }
}

