/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class CrateControlListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @EventHandler
    public void onPistonPushCrate(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            Location location = block.getLocation();
            Crate crate = this.crateManager.getCrateFromLocation(location);
            if (crate == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonPullCrate(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            Location location = block.getLocation();
            Crate crate = this.crateManager.getCrateFromLocation(location);
            if (crate == null) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.crateManager.hasCrateTask(player)) {
            this.crateManager.endCrate(player);
        }
        if (this.crateManager.hasQuadCrateTask(player)) {
            this.crateManager.endQuadCrate(player);
        }
        if (this.crateManager.isInOpeningList(player)) {
            this.crateManager.removePlayerFromOpeningList(player);
        }
    }
}

