/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.api;

import ch.jalu.configme.SettingsManager;
import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import com.ryderbelserion.fusion.core.FusionProvider;
import com.ryderbelserion.fusion.core.api.commands.ICommandManager;
import com.ryderbelserion.fusion.core.api.interfaces.IFileManager;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import com.ryderbelserion.fusion.core.api.utils.keys.ConfigKeys;
import com.ryderbelserion.fusion.core.plugins.FusionPluginManager;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FusionCore {
    protected final SettingsManager config;
    private final FusionPluginManager pluginManager;
    private final ComponentLogger logger;
    private final Path path;

    public FusionCore(@NotNull ComponentLogger logger, @NotNull Path path, @Nullable Consumer<SettingsManagerBuilder> consumer) {
        this.logger = logger;
        this.path = path;
        FusionProvider.register(this);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException exception) {
                this.log("error", "Failed to create {}! Exception: {}", path, exception.getMessage());
            }
        }
        SettingsManagerBuilder builder = SettingsManagerBuilder.withYamlFile(this.path.resolve("fusion.yml"), YamlFileResourceOptions.builder().charset(StandardCharsets.UTF_8).indentationSize(2).build());
        builder.useDefaultMigrationService();
        if (consumer != null) {
            consumer.accept(builder);
        }
        this.config = builder.create();
        this.pluginManager = new FusionPluginManager();
    }

    public abstract String parsePlaceholders(@NotNull Audience var1, @NotNull String var2);

    public abstract ICommandManager getCommandManager();

    public abstract IFileManager getFileManager();

    public abstract String chomp(@NotNull String var1);

    public boolean isPluginEnabled(String name) {
        return false;
    }

    @Nullable
    public <T> T createProfile(@NotNull UUID uuid, @Nullable String name) {
        return null;
    }

    @NotNull
    public Component color(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders, @NotNull List<TagResolver> tags) {
        ArrayList<TagResolver> resolvers = new ArrayList<TagResolver>(tags);
        placeholders.forEach((placeholder, value) -> resolvers.add((TagResolver)Placeholder.parsed((String)StringUtils.replaceAllBrackets(placeholder).toLowerCase(), (String)value)));
        return AdvUtils.parse(this.parsePlaceholders(audience, StringUtils.replaceBrackets(message)), TagResolver.resolver(resolvers));
    }

    @NotNull
    public Component color(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders) {
        return this.color(audience, message, placeholders, List.of());
    }

    @NotNull
    public Component color(@NotNull String message, @NotNull Map<String, String> placeholders) {
        return this.color(Audience.empty(), message, placeholders);
    }

    @NotNull
    public Component color(@NotNull String message) {
        return this.color(Audience.empty(), message, new HashMap<String, String>());
    }

    public void sendMessage(@NotNull Audience audience, @NotNull String message, @NotNull Map<String, String> placeholders) {
        audience.sendMessage(this.color(audience, message, placeholders));
    }

    public void sendMessage(@NotNull Audience audience, @NotNull List<String> messages, @NotNull Map<String, String> placeholders) {
        messages.forEach(message -> this.sendMessage(audience, (String)message, placeholders));
    }

    public void log(@NotNull String type, @NotNull String message, @NotNull Throwable throwable) {
        if (!this.isVerbose()) {
            return;
        }
        Component component = AdvUtils.parse(message);
        switch (type) {
            case "info": {
                this.logger.info(component, throwable);
                break;
            }
            case "error": {
                this.logger.error(component, throwable);
                break;
            }
            case "warn": {
                this.logger.warn(component, throwable);
            }
        }
    }

    public void log(@NotNull String type, @NotNull String message, Object ... args) {
        if (!this.isVerbose()) {
            return;
        }
        Component component = AdvUtils.parse(message);
        switch (type) {
            case "info": {
                this.logger.info(component, args);
                break;
            }
            case "error": {
                this.logger.error(component, args);
                break;
            }
            case "warn": {
                this.logger.warn(component, args);
            }
        }
    }

    public void enable() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectory(this.path, new FileAttribute[0]);
            }
            catch (IOException exception) {
                this.log("error", "Failed to create {}! Exception: {}", this.path, exception.getMessage());
            }
        }
    }

    public void reload() {
        this.config.reload();
    }

    public void disable() {
        FusionProvider.unregister();
    }

    @NotNull
    public final FusionPluginManager getPluginManager() {
        return this.pluginManager;
    }

    @NotNull
    public final ComponentLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getRoundingFormat() {
        return this.config.getProperty(ConfigKeys.rounding_format);
    }

    @NotNull
    public final String getNumberFormat() {
        return this.config.getProperty(ConfigKeys.number_format);
    }

    public boolean isVerbose() {
        return this.config.getProperty(ConfigKeys.is_verbose);
    }

    public int getDepth() {
        return this.config.getProperty(ConfigKeys.recursion_depth);
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }
}

