/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.builders.items;

import com.ryderbelserion.fusion.paper.api.builders.items.BaseItemBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.PatternBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.PotionBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.SkullBuilder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder
extends BaseItemBuilder<ItemBuilder> {
    ItemBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    ItemBuilder(@NotNull String value) {
        super(value);
    }

    @NotNull
    public static PotionBuilder potion(@NotNull ItemType itemType, int amount) {
        return new PotionBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    @NotNull
    public static PotionBuilder potion(@NotNull ItemType itemType) {
        return ItemBuilder.potion(itemType, 1);
    }

    @NotNull
    public static SkullBuilder skull(@NotNull ItemType itemType, int amount) {
        return new SkullBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    @NotNull
    public static SkullBuilder skull(@NotNull ItemType itemType) {
        return ItemBuilder.skull(itemType, 1);
    }

    @NotNull
    public static PatternBuilder pattern(@NotNull ItemType itemType, int amount) {
        return new PatternBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    @NotNull
    public static PatternBuilder pattern(@NotNull ItemType itemType) {
        return ItemBuilder.pattern(itemType, 1);
    }

    @NotNull
    public static ItemBuilder from(@NotNull ItemType itemType, int amount) {
        return new ItemBuilder(itemType.createItemStack(Math.max(amount, 1)));
    }

    @NotNull
    public static ItemBuilder from(@NotNull ItemStack itemStack) {
        return new ItemBuilder(itemStack);
    }

    @NotNull
    public static ItemBuilder from(@NotNull ItemType itemType) {
        return ItemBuilder.from(itemType, 1);
    }

    @NotNull
    public static ItemBuilder from(@NotNull String value) {
        return new ItemBuilder(value);
    }
}

