/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.api.builders.items.types.fireworks;

import com.ryderbelserion.fusion.paper.api.builders.items.BaseItemBuilder;
import com.ryderbelserion.fusion.paper.api.builders.items.types.fireworks.FireworkStarBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.Fireworks;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FireworkBuilder
extends BaseItemBuilder<FireworkBuilder> {
    private final Fireworks.Builder builder = Fireworks.fireworks();

    public FireworkBuilder(@NotNull ItemStack itemStack) {
        super(itemStack);
    }

    @NotNull
    public FireworkBuilder addEffect(@NotNull FireworkEffect effect) {
        this.builder.addEffect(effect);
        return this;
    }

    @NotNull
    public FireworkBuilder addEffect(boolean flicker, boolean trail, @NotNull FireworkEffect.Type type, @Nullable List<Color> colors, @Nullable List<Color> fadeColors) {
        FireworkStarBuilder builder = new FireworkStarBuilder(this.getItem());
        builder.flicker(flicker);
        builder.trail(trail);
        builder.with(type);
        if (colors != null) {
            builder.withColor(colors);
        }
        if (fadeColors != null) {
            builder.withFade(fadeColors);
        }
        return this.addEffect(builder.getBuilder().build());
    }

    @NotNull
    public FireworkBuilder withDuration(int duration) {
        this.builder.flightDuration(duration);
        return this;
    }

    @Override
    @NotNull
    public FireworkBuilder build() {
        this.getItem().setData(DataComponentTypes.FIREWORKS, (Object)((Fireworks)this.builder.build()));
        return this;
    }
}

