/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.command.InternalCommand;
import dev.triumphteam.cmd.core.command.InternalParentCommand;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.meta.MetaKey;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.processor.BranchCommandProcessor;
import dev.triumphteam.cmd.core.processor.CommandProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InternalBranchCommand<D, S, ST>
extends InternalParentCommand<D, S, ST> {
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;
    private final Object invocationInstance;
    private final Constructor<?> constructor;
    private final boolean isStatic;
    private final StringInternalArgument<S, ST> argument;
    private final boolean hasArgument;

    public InternalBranchCommand(@NotNull Object invocationInstance, @NotNull Constructor<?> constructor, boolean isStatic, @Nullable StringInternalArgument<S, ST> argument, @NotNull BranchCommandProcessor<D, S, ST> processor, @NotNull InternalCommand<D, S, ST> parentCommand) {
        super(processor);
        this.invocationInstance = invocationInstance;
        this.constructor = constructor;
        this.isStatic = isStatic;
        this.argument = argument;
        this.hasArgument = argument != null;
        this.name = processor.getName();
        this.description = this.getMeta().getOrDefault(MetaKey.DESCRIPTION, "");
        this.aliases = processor.getAliases();
        this.syntax = this.createSyntax(parentCommand, processor);
    }

    public void execute(@NotNull S sender, @Nullable Supplier<Object> instanceSupplier, @NotNull Deque<String> arguments) throws Throwable {
        Object instance;
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        if (this.hasArgument) {
            String argumentName = arguments.peek() == null ? "" : arguments.pop();
            @NotNull InternalArgumentResult result = this.argument.resolve(sender, new ArgumentInput(argumentName));
            if (result instanceof InternalArgumentResult.Invalid) {
                this.getMessageRegistry().sendMessage(MessageKey.INVALID_ARGUMENT, sender, ((InternalArgumentResult.Invalid)result).getFail().apply(this.getMeta(), this.syntax));
                return;
            }
            if (!(result instanceof InternalArgumentResult.Valid)) {
                throw new CommandExecutionException("An error occurred resolving arguments", "", this.name);
            }
            instance = this.createInstanceWithArgument(instanceSupplier, ((InternalArgumentResult.Valid)result).getValue());
        } else {
            instance = this.createInstance(instanceSupplier);
        }
        this.findAndExecute(sender, () -> instance, arguments);
    }

    @Override
    @NotNull
    public List<ST> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        if (arguments.size() == 1 && this.hasArgument) {
            return this.argument.suggestions(sender, arguments.peekLast(), new ArrayList<String>(arguments), Collections.emptyMap());
        }
        if (this.hasArgument) {
            arguments.pop();
        }
        return super.suggestions(sender, arguments);
    }

    @NotNull
    public Object createInstance(@Nullable Supplier<Object> instanceSupplier) {
        try {
            if (!this.isStatic) {
                return this.constructor.newInstance(instanceSupplier == null ? this.invocationInstance : instanceSupplier.get());
            }
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            throw new CommandExecutionException("An error occurred while creating the command instance").initCause(exception instanceof InvocationTargetException ? exception.getCause() : exception);
        }
    }

    @NotNull
    private Object createInstanceWithArgument(@Nullable Supplier<Object> instanceSupplier, @Nullable Object argumentValue) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        if (!this.isStatic) {
            return this.constructor.newInstance(instanceSupplier == null ? this.invocationInstance : instanceSupplier.get(), argumentValue);
        }
        return this.constructor.newInstance(argumentValue);
    }

    @NotNull
    private String createSyntax(@NotNull InternalCommand<D, S, ST> parentCommand, @NotNull CommandProcessor<D, S, ST> processor) {
        Syntax syntaxAnnotation = processor.getSyntaxAnnotation();
        if (syntaxAnnotation != null) {
            return syntaxAnnotation.value();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(parentCommand.getSyntax()).append(" ");
        if (this.hasArgument) {
            builder.append("<").append(this.argument.getName()).append(">");
        } else {
            builder.append(this.name);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean hasArguments() {
        return this.argument != null;
    }

    @Override
    public boolean isHidden() {
        return this.argument != null;
    }
}

