/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.core;

import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.impl.Settings;
import com.ryderbelserion.fusion.core.api.utils.FileUtils;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.CratesProvider;
import us.crazycrew.crazycrates.api.users.UserManager;
import us.crazycrew.crazycrates.platform.IServer;
import us.crazycrew.crazycrates.platform.ISettings;

public class Server
implements IServer {
    private final Path path;
    private final Path crates;
    private UserManager userManager;
    private Settings settings;

    public Server(@NotNull Path path) {
        this.path = path;
        this.crates = this.path.resolve("crates");
    }

    public void apply() {
        ConfigManager.load(this.path);
        this.settings = new Settings();
        CratesProvider.register(this);
    }

    public void setUserManager(@NotNull UserManager userManager) {
        if (this.userManager != null) {
            return;
        }
        this.userManager = userManager;
    }

    public void disable() {
        CratesProvider.unregister();
    }

    @Override
    public void reload() {
        ConfigManager.refresh();
    }

    @Override
    @NotNull
    public Path getCratesPath() {
        return this.crates;
    }

    @Override
    @NotNull
    public Path getDataPath() {
        return this.path;
    }

    @Override
    @NotNull
    public final List<String> getCrateFiles(boolean keepExtension) {
        return keepExtension ? FileUtils.getNamesByExtension("crates", this.path, ".yml") : FileUtils.getNamesWithoutExtension("crates", this.path, ".yml");
    }

    @Override
    @NotNull
    public final List<String> getCrateFiles() {
        return this.getCrateFiles(false);
    }

    @Override
    @NotNull
    public final UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    @NotNull
    public final ISettings getSettings() {
        return this.settings;
    }
}

