/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.keys;

import com.badbones69.crazycrates.paper.api.PlayerBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.Permissions;
import com.badbones69.crazycrates.paper.api.events.PlayerReceiveKeyEvent;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.commands.crates.types.BaseCommand;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Flag;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import dev.triumphteam.cmd.core.argument.keyed.Flags;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.PermissionDefault;
import us.crazycrew.crazycrates.api.enums.types.CrateType;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CommandGive
extends BaseCommand {
    @Command(value="give")
    @Flag(flag="s", longFlag="silent")
    @Permission(value={"crazycrates.givekey"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates give <key_type> <crate_name> <amount> <player_name> [-s/--silent]")
    public void give(CommandSender sender, @ArgName(value="key_type") @Suggestion(value="keys") String type, @ArgName(value="crate") @Suggestion(value="crates") String crateName, @ArgName(value="amount") @Suggestion(value="numbers") int amount, @ArgName(value="player") @Suggestion(value="players") PlayerBuilder target, Flags flags) {
        boolean isSilent = flags.hasFlag("s");
        if (crateName == null || crateName.isBlank()) {
            Messages.cannot_be_empty.sendMessage(sender, "{value}", "crate name");
            return;
        }
        if (amount <= 0) {
            Messages.not_a_number.sendMessage(sender, "{number}", String.valueOf(amount));
            return;
        }
        Crate crate = this.getCrate(sender, crateName, false);
        if (crate == null || crate.getCrateType() == CrateType.menu) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        KeyType keyType = this.getKeyType(type);
        if (target.getPlayer() != null) {
            this.addKey(sender, target.getPlayer(), crate, keyType, amount, isSilent);
            return;
        }
        this.addKey(sender, target.getOfflinePlayer(), crate, keyType, amount, isSilent);
    }

    @Command(value="give-random")
    @Flag(flag="s", longFlag="silent")
    @Permission(value={"crazycrates.giverandomkey"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates give-random <key_type> <crate_name> <amount> <player_name> [-s/--silent]")
    public void random(CommandSender sender, @Suggestion(value="keys") String type, @Suggestion(value="numbers") int amount, @Suggestion(value="players") PlayerBuilder target, Flags flags) {
        this.give(sender, type, this.crateManager.getUsableCrates().get((int)MiscUtils.pickNumber(0L, this.crateManager.getUsableCrates().size() - 2)).getFileName(), amount, target, flags);
    }

    @Command(value="giveall")
    @Flag(flag="s", longFlag="silent")
    @Permission(value={"crazycrates.giveall"}, def=PermissionDefault.OP)
    @Syntax(value="/crazycrates giveall <key_type> <crate_name> <amount> [-s/--silent]")
    public void all(CommandSender sender, @Suggestion(value="keys") String type, @Suggestion(value="crates") String crateName, final @Suggestion(value="numbers") int amount, Flags flags) {
        boolean isSilent = flags.hasFlag("s");
        if (crateName.isEmpty()) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        if (amount <= 0) {
            Messages.not_a_number.sendMessage(sender, "{amount}", String.valueOf(amount));
            return;
        }
        final Crate crate = this.getCrate(sender, crateName, false);
        if (crate == null) {
            Messages.not_a_crate.sendMessage(sender, "{crate}", crateName);
            return;
        }
        final KeyType keyType = this.getKeyType(type);
        Messages.given_everyone_keys.sendMessage(sender, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("{keytype}", keyType.getFriendlyName());
                this.put("{amount}", String.valueOf(amount));
                this.put("{key}", crate.getKeyName());
            }
        });
        for (Player player : this.server.getOnlinePlayers()) {
            if (Permissions.CRAZYCRATES_PLAYER_EXCLUDE.hasPermission(player)) continue;
            PlayerReceiveKeyEvent event = new PlayerReceiveKeyEvent(player, crate, PlayerReceiveKeyEvent.KeyReceiveReason.GIVE_ALL_COMMAND, amount);
            this.pluginManager.callEvent((Event)event);
            if (event.isCancelled()) continue;
            this.addKey(sender, player, crate, keyType, amount, isSilent, true);
        }
    }
}

