/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.sound.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CasinoCrate
extends CrateBuilder {
    private final Inventory inventory = this.getInventory();
    private final Player player = this.getPlayer();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();
    private int counter = 0;
    private int time = 1;
    private int open = 0;

    public CasinoCrate(@NotNull Crate crate, @NotNull Player player, int size) {
        super(crate, player, size);
    }

    @Override
    public void run() {
        if (this.isCancelled) {
            return;
        }
        if (this.counter <= 50) {
            this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
            this.cycle();
        }
        ++this.open;
        if (this.open >= 5) {
            this.player.openInventory(this.inventory);
            this.open = 0;
        }
        ++this.counter;
        if (this.counter > 51) {
            if (MiscUtils.slowSpin(120, 15).contains(this.time)) {
                this.playSound("cycle-sound", Sound.Source.MASTER, "block.note_block.xylophone");
                this.cycle();
            }
            ++this.time;
            if (this.time >= 60) {
                this.playSound("stop-sound", Sound.Source.MASTER, "entity.player.levelup");
                this.crateManager.endCrate(this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 11, this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 13, this.player);
                PrizeManager.getPrize(this.crate, this.inventory, 15, this.player);
                this.crateManager.removePlayerFromOpeningList(this.player);
                new FoliaScheduler(this.plugin, null, (Entity)this.player){

                    @Override
                    public void run() {
                        if (CasinoCrate.this.player.getOpenInventory().getTopInventory().equals((Object)CasinoCrate.this.inventory)) {
                            CasinoCrate.this.player.closeInventory();
                        }
                    }
                }.runDelayed(40L);
                this.cancel();
                return;
            }
        }
        ++this.counter;
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, @NotNull EventType eventType) {
        boolean keyCheck;
        boolean isRandom;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        ConfigurationSection section = this.crate.getFile().getConfigurationSection("Crate.random");
        if (section != null && !(isRandom = section.getBoolean("toggle", false))) {
            @Nullable Tier tier_uno = this.crate.getTier(section.getString("types.row-3", ""));
            @Nullable Tier tier_dos = this.crate.getTier(section.getString("types.row-2", ""));
            @Nullable Tier tier_tres = this.crate.getTier(section.getString("types.row-1", ""));
            if (tier_uno == null || tier_dos == null || tier_tres == null) {
                if (MiscUtils.isLogging()) {
                    this.logger.warn("One of your tiers in {} could not be found, or is empty. Search for row-1, row-2 or row-3", (Object)fileName);
                }
                this.crateManager.endCrate(this.player);
                this.crateManager.removeCrateTask(this.player);
                this.crateManager.removePlayerFromOpeningList(this.player);
                this.player.closeInventory();
                return;
            }
        }
        if (!(keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, checkHand))) {
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.setDisplayItems(true);
        this.runAtFixedRate(1L, 1L);
        this.player.openInventory(this.inventory);
    }

    private void setDisplayItems(boolean isStatic) {
        ConfigurationSection section = this.crate.getFile().getConfigurationSection("Crate.random");
        boolean isGlassBorderToggled = this.crate.isGlassBorderToggled();
        if (isStatic && isGlassBorderToggled) {
            for (int index = 0; index < 27; ++index) {
                this.setItem(index, this.getRandomGlassPane());
            }
        }
        if (section != null) {
            Tier tierTres;
            Tier tierDos;
            boolean isRandom = section.getBoolean("toggle", false);
            if (isRandom) {
                List<Tier> tiers = this.crate.getTiers();
                int size = tiers.size();
                ThreadLocalRandom random = ThreadLocalRandom.current();
                this.setItem(2, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(11, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(20, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(4, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(13, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(22, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(6, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(15, this.getDisplayItem(tiers.get(random.nextInt(size))));
                this.setItem(24, this.getDisplayItem(tiers.get(random.nextInt(size))));
                return;
            }
            @Nullable Tier tierUno = this.crate.getTier(section.getString("types.row-1", ""));
            if (tierUno != null) {
                this.setItem(2, this.getDisplayItem(tierUno));
                this.setItem(11, this.getDisplayItem(tierUno));
                this.setItem(20, this.getDisplayItem(tierUno));
            }
            if ((tierDos = this.crate.getTier(section.getString("types.row-2", ""))) != null) {
                this.setItem(4, this.getDisplayItem(tierDos));
                this.setItem(13, this.getDisplayItem(tierDos));
                this.setItem(22, this.getDisplayItem(tierDos));
            }
            if ((tierTres = this.crate.getTier(section.getString("types.row-3", ""))) != null) {
                this.setItem(6, this.getDisplayItem(tierTres));
                this.setItem(15, this.getDisplayItem(tierTres));
                this.setItem(24, this.getDisplayItem(tierTres));
            }
        }
    }

    private void cycle() {
        for (int index = 0; index < 27; ++index) {
            PersistentDataContainerView container;
            ItemStack itemStack = this.inventory.getItem(index);
            if (itemStack == null || (container = itemStack.getPersistentDataContainer()).has(ItemKeys.crate_prize.getNamespacedKey())) continue;
            this.setItem(index, this.getRandomGlassPane());
        }
        this.setDisplayItems(false);
    }
}

