/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.menus;

import com.badbones69.crazycrates.core.config.beans.ModelData;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.builders.gui.StaticInventoryBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.Gui;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiFiller;
import java.text.NumberFormat;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class CrateMainMenu
extends StaticInventoryBuilder {
    private final Player player = this.getPlayer();
    private final Gui gui = this.getGui();

    public CrateMainMenu(@NotNull Player player, @NotNull String title, int rows) {
        super(player, title, rows);
    }

    @Override
    public void open() {
        UUID uuid = this.player.getUniqueId();
        if (this.config.getProperty(ConfigKeys.filler_toggle).booleanValue()) {
            GuiFiller guiFiller = this.gui.getFiller();
            ModelData fillerModel = this.config.getProperty(ConfigKeys.filler_item_model);
            guiFiller.fill(((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin).withType(this.config.getProperty(ConfigKeys.filler_item))).setDisplayName(this.config.getProperty(ConfigKeys.filler_name))).setDisplayLore(this.config.getProperty(ConfigKeys.filler_lore))).setCustomModelData(this.config.getProperty(ConfigKeys.filler_model_data))).setItemModel(fillerModel.getNamespace(), fillerModel.getId())).asGuiItem());
        }
        if (this.config.getProperty(ConfigKeys.gui_customizer_toggle).booleanValue()) {
            for (String custom : this.config.getProperty(ConfigKeys.gui_customizer)) {
                LegacyItemBuilder item = new LegacyItemBuilder(this.plugin);
                int slot = 0;
                block23: for (String key : custom.split(", ")) {
                    String option = key.split(":")[0];
                    String value = key.replace(option + ":", "").replace(option, "");
                    switch (option.toLowerCase()) {
                        case "item": {
                            item.withType(value.toLowerCase());
                            continue block23;
                        }
                        case "name": {
                            item.setDisplayName(this.getCrates(value).replace("{player}", this.player.getName()));
                            continue block23;
                        }
                        case "lore": {
                            String[] lore;
                            for (String line : lore = value.split(",")) {
                                item.addDisplayLore(this.getCrates(line).replace("{player}", this.player.getName()));
                            }
                            continue block23;
                        }
                        case "custom-model-data": {
                            item.setCustomModelData(value);
                            continue block23;
                        }
                        case "glowing": {
                            item.setGlowing(StringUtils.tryParseBoolean(value).orElse(false));
                            continue block23;
                        }
                        case "slot": {
                            slot = StringUtils.tryParseInt(value).orElse(-1).intValue();
                            continue block23;
                        }
                        case "unbreakable-item": {
                            item.setUnbreakable(StringUtils.tryParseBoolean(value).orElse(false));
                            continue block23;
                        }
                        case "hide-item-flags": {
                            item.setHidingItemFlags(StringUtils.tryParseBoolean(value).orElse(false));
                            continue block23;
                        }
                        case "command": {
                            MiscUtils.sendCommand(value);
                        }
                    }
                }
                this.gui.setItem(slot, ((LegacyItemBuilder)item.setPlayer(this.player)).asGuiItem());
            }
        }
        for (Crate crate : this.crateManager.getUsableCrates()) {
            YamlConfiguration file = crate.getFile();
            ConfigurationSection section = file.getConfigurationSection("Crate");
            if (section == null || !section.getBoolean("InGUI", false)) continue;
            String fileName = crate.getFileName();
            int slot = section.getInt("Slot");
            int virtualKeys = this.userManager.getVirtualKeys(uuid, fileName);
            int physicalKeys = this.userManager.getPhysicalKeys(uuid, fileName);
            int totalKeys = virtualKeys + physicalKeys;
            int openedCrates = this.userManager.getCrateOpened(uuid, fileName);
            NumberFormat instance = NumberFormat.getNumberInstance();
            LegacyItemBuilder builder = (LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin).withType(section.getString("Item", "chest").toLowerCase())).setDisplayName(crate.getCrateName())).setCustomModelData(section.getString("Custom-Model-Data", ""))).setItemModel(section.getString("Model.Namespace", ""), section.getString("Model.Id", ""))).addLorePlaceholder("%keys%", instance.format(virtualKeys))).addLorePlaceholder("%keys_physical%", instance.format(physicalKeys))).addLorePlaceholder("%keys_total%", instance.format(totalKeys))).addLorePlaceholder("%crate_opened%", instance.format(openedCrates))).addLorePlaceholder("%keys_raw%", String.valueOf(virtualKeys))).addLorePlaceholder("%keys_physical_raw%", String.valueOf(physicalKeys))).addLorePlaceholder("%keys_total_raw%", String.valueOf(totalKeys))).addLorePlaceholder("%crate_opened_raw", String.valueOf(openedCrates))).addLorePlaceholder("%player%", this.player.getName())).setPersistentString(ItemKeys.crate_key.getNamespacedKey(), fileName);
            this.gui.setItem(slot, ItemUtils.getItem(section, builder, this.player).asGuiItem(event -> {
                String fancyName = crate.getCrateName();
                switch (event.getClick()) {
                    case LEFT: {
                        boolean isLeftClickToPreview = this.config.getProperty(ConfigKeys.crate_virtual_interaction);
                        if (isLeftClickToPreview) {
                            this.openPreview(crate, fancyName);
                            break;
                        }
                        this.openCrate(uuid, crate, fileName, fancyName);
                        break;
                    }
                    case RIGHT: {
                        boolean isRightClickToOpen = this.config.getProperty(ConfigKeys.crate_virtual_interaction);
                        if (isRightClickToOpen) {
                            this.openCrate(uuid, crate, fileName, fancyName);
                            break;
                        }
                        this.openPreview(crate, fancyName);
                    }
                }
            }));
        }
        this.gui.open(this.player);
    }

    private void openCrate(@NotNull UUID uuid, @NotNull Crate crate, @NotNull String fileName, @NotNull String fancyName) {
        if (this.crateManager.isInOpeningList(this.player)) {
            Messages.already_opening_crate.sendMessage((CommandSender)this.player, "{crate}", fancyName);
            return;
        }
        boolean hasKey = false;
        KeyType keyType = KeyType.virtual_key;
        if (this.userManager.getVirtualKeys(uuid, fileName) >= 1) {
            hasKey = true;
        } else if (this.config.getProperty(ConfigKeys.virtual_accepts_physical_keys).booleanValue() && this.userManager.hasPhysicalKey(uuid, fileName, false)) {
            hasKey = true;
            keyType = KeyType.physical_key;
        }
        if (!hasKey) {
            if (this.config.getProperty(ConfigKeys.need_key_sound_toggle).booleanValue()) {
                String property = this.config.getProperty(ConfigKeys.need_key_sound);
                Sound sound = Sound.sound((Key)Key.key((String)property), (Sound.Source)Sound.Source.MASTER, (float)1.0f, (float)1.0f);
                this.player.playSound(sound);
            }
            Messages.no_virtual_key.sendMessage((CommandSender)this.player, "{crate}", fancyName);
            return;
        }
        for (String world : this.config.getProperty(ConfigKeys.disabled_worlds)) {
            if (!world.equalsIgnoreCase(this.player.getWorld().getName())) continue;
            Messages.world_disabled.sendMessage((CommandSender)this.player, "{world}", this.player.getWorld().getName());
            return;
        }
        if (MiscUtils.isInventoryFull(this.player)) {
            Messages.inventory_not_empty.sendMessage((CommandSender)this.player, "{crate}", fancyName);
            return;
        }
        this.crateManager.openCrate(this.player, crate, keyType, this.player.getLocation(), true, false, EventType.event_crate_opened);
    }

    private void openPreview(@NotNull Crate crate, @NotNull String fancyName) {
        if (crate.isPreviewEnabled()) {
            crate.playSound(this.player, this.player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
            this.gui.close(this.player, InventoryCloseEvent.Reason.OPEN_NEW, false);
            this.inventoryManager.openNewCratePreview(this.player, crate);
        } else {
            Messages.preview_disabled.sendMessage((CommandSender)this.player, "{crate}", fancyName);
        }
    }
}

