/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.paper.files;

import ch.jalu.configme.SettingsManagerBuilder;
import ch.jalu.configme.resource.YamlFileResourceOptions;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.interfaces.IFileManager;
import com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import com.ryderbelserion.fusion.core.api.utils.FileUtils;
import com.ryderbelserion.fusion.core.files.types.JaluCustomFile;
import com.ryderbelserion.fusion.core.files.types.LogCustomFile;
import com.ryderbelserion.fusion.core.files.types.YamlCustomFile;
import com.ryderbelserion.fusion.paper.files.types.NbtCustomFile;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationOptions;

public class FileManager
extends IFileManager {
    protected final Map<Path, ICustomFile<? extends ICustomFile<?>>> customFiles = new HashMap();
    protected final Map<Path, FileType> folders = new HashMap<Path, FileType>();

    @Override
    @NotNull
    public final FileManager init(@NotNull List<FileAction> actions) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                Files.createDirectory(this.path, new FileAttribute[0]);
            }
            catch (IOException exception) {
                this.fusion.log("error", "Failed to create {}! Exception: {}", this.path, exception.getMessage());
            }
        }
        this.folders.forEach((folder, type) -> this.addFolder((Path)folder, (FileType)((Object)type), (List)actions, (UnaryOperator)null));
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFolder(@NotNull Path folder, @NotNull Consumer<SettingsManagerBuilder> builder, @NotNull List<FileAction> actions, @Nullable YamlFileResourceOptions options) {
        this.folders.put(folder, FileType.JALU);
        this.extractFolder(folder, (List)actions);
        List<Path> files = FileUtils.getFiles(this.path.resolve(folder), ".yml", this.fusion.getDepth());
        for (Path path : files) {
            this.addFile(path, (Consumer)builder, (List)actions, options);
        }
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFolder(@NotNull Path folder, @NotNull Consumer<SettingsManagerBuilder> builder, @NotNull List<FileAction> actions) {
        return this.addFolder(folder, (Consumer)builder, (List)actions, (YamlFileResourceOptions)null);
    }

    @Override
    @NotNull
    public final FileManager addFolder(@NotNull Path folder, @NotNull Consumer<SettingsManagerBuilder> builder) {
        return this.addFolder(folder, (Consumer)builder, (List)new ArrayList());
    }

    @Override
    @NotNull
    public final FileManager addFolder(@NotNull Path folder, @NotNull FileType fileType, @NotNull List<FileAction> actions, @Nullable UnaryOperator<ConfigurationOptions> options) {
        this.folders.put(folder, fileType);
        this.extractFolder(folder, (List)actions);
        List<Path> files = FileUtils.getFiles(folder, fileType.getExtension(), this.fusion.getDepth());
        for (Path path : files) {
            this.addFile(path, fileType, (List)actions, (UnaryOperator)options);
        }
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFolder(@NotNull Path folder, @NotNull FileType fileType) {
        this.addFolder(folder, fileType, (List)new ArrayList(), (UnaryOperator)null);
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull Consumer<SettingsManagerBuilder> builder, @NotNull List<FileAction> actions, @Nullable YamlFileResourceOptions options) {
        ICustomFile file = this.customFiles.getOrDefault(path, null);
        if (file != null && !actions.contains((Object)FileAction.RELOAD_FILE)) {
            file.load();
            return this;
        }
        if (this.customFiles.containsKey(path)) {
            this.fusion.log("info", "Path {} already exists in the cache, so we don't need to rebuild it", path);
            return this;
        }
        JaluCustomFile jalu = new JaluCustomFile(path, builder, actions, options);
        this.customFiles.putIfAbsent(path, jalu.load());
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull Consumer<SettingsManagerBuilder> builder, @NotNull List<FileAction> actions) {
        return this.addFile(path, (Consumer)builder, (List)actions, (YamlFileResourceOptions)null);
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull Consumer<SettingsManagerBuilder> builder) {
        return this.addFile(path, (Consumer)builder, (List)new ArrayList());
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull FileType fileType, @NotNull List<FileAction> actions, @Nullable UnaryOperator<ConfigurationOptions> options) {
        ICustomFile file;
        String fileName = path.getFileName().toString();
        if (!Files.exists(path, new LinkOption[0])) {
            FileUtils.extract(fileName, path.getParent(), actions);
        }
        if ((file = (ICustomFile)this.customFiles.getOrDefault(path, null)) != null && !actions.contains((Object)FileAction.RELOAD_FILE)) {
            file.load();
            return this;
        }
        if (this.customFiles.containsKey(path)) {
            this.fusion.log("info", "Path {} already exists in the cache, so we don't need to rebuild it", path);
            return this;
        }
        ICustomFile customFile = null;
        switch (fileType) {
            case CONFIGURATE: {
                customFile = new YamlCustomFile(path, actions, options).load();
                break;
            }
            case PAPER: {
                customFile = new PaperCustomFile(path, actions).load();
                break;
            }
            case LOG: {
                customFile = new LogCustomFile(path, actions).load();
                break;
            }
            case NBT: {
                customFile = new NbtCustomFile(path, actions).load();
                break;
            }
        }
        if (customFile != null) {
            this.customFiles.putIfAbsent(path, customFile);
        }
        return this;
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull FileType fileType, @NotNull List<FileAction> actions) {
        return this.addFile(path, fileType, (List)actions, (UnaryOperator)null);
    }

    @Override
    @NotNull
    public final FileManager addFile(@NotNull Path path, @NotNull FileType fileType) {
        return this.addFile(path, fileType, (List)new ArrayList(), (UnaryOperator)null);
    }

    @Override
    @NotNull
    public IFileManager addFile(@NotNull ICustomFile customFile) {
        this.customFiles.putIfAbsent(customFile.getPath(), customFile);
        return this;
    }

    @Override
    @NotNull
    public final FileManager saveFile(@NotNull Path path, @NotNull List<FileAction> actions, @NotNull String content) {
        ICustomFile file = this.customFiles.getOrDefault(path, null);
        if (file == null) {
            this.fusion.log("warn", "Cannot write to file as the file does not exist.", new Object[0]);
            return this;
        }
        if (file.getFileType() != FileType.LOG) {
            this.fusion.log("warn", "The file {} is not a log file.", file.getFileName());
            return this;
        }
        file.save(content, actions);
        return this;
    }

    @Override
    @NotNull
    public final FileManager saveFile(@NotNull Path path) {
        ICustomFile file = this.customFiles.getOrDefault(path, null);
        if (file == null) {
            this.fusion.log("warn", "Cannot write to file as the file does not exist.", new Object[0]);
            return this;
        }
        if (file.getFileType() == FileType.LOG) {
            this.fusion.log("warn", "Please use the correct method FileManager#saveFile(path, content) to write to log files!", new Object[0]);
            return this;
        }
        file.save();
        return this;
    }

    @Override
    @NotNull
    public final FileManager removeFile(@NotNull Path path, @Nullable FileAction action) {
        if (!this.customFiles.containsKey(path)) {
            return this;
        }
        ICustomFile<ICustomFile<?>> file = this.customFiles.get(path);
        if (action == FileAction.DELETE_FILE) {
            file.delete();
        }
        if (action == FileAction.DELETE_CACHE) {
            this.customFiles.remove(path);
            return this;
        }
        file.save();
        return this;
    }

    @Override
    @NotNull
    public final FileManager removeFile(@NotNull Path path) {
        return this.removeFile(path, null);
    }

    @Override
    @NotNull
    public final FileManager removeFile(@NotNull ICustomFile<? extends ICustomFile<?>> customFile, @Nullable FileAction action) {
        this.removeFile(customFile.getPath(), action);
        return this;
    }

    @Override
    @NotNull
    public final FileManager removeFile(@NotNull ICustomFile<? extends ICustomFile<?>> customFile) {
        return this.removeFile((ICustomFile)customFile, (FileAction)null);
    }

    @Override
    @NotNull
    public final FileManager purge() {
        this.customFiles.clear();
        this.folders.clear();
        return this;
    }

    @Override
    @NotNull
    public final FileManager extractFolder(@NotNull Path folder, @NotNull List<FileAction> actions) {
        if (!actions.contains((Object)FileAction.EXTRACT_FOLDER)) {
            this.fusion.log("info", "The file action EXTRACT_FOLDER was not specified for {}, You can ignore this.", folder);
            return this;
        }
        FileUtils.extract(folder.getFileName().toString(), this.path, actions);
        return this;
    }

    @Override
    @NotNull
    public final FileManager extractResource(@NotNull String path, @NotNull String output, final @NotNull FileAction action) {
        FileUtils.extract(path, this.path.resolve(output), (List<FileAction>)new ArrayList<FileAction>(){
            {
                this.add(action);
            }
        });
        return this;
    }

    @Override
    @NotNull
    public final FileManager extractResource(@NotNull String path) {
        FileUtils.extract(path, this.path, new ArrayList<FileAction>());
        return this;
    }

    @Override
    @Nullable
    public final ICustomFile<? extends ICustomFile<?>> getCustomFile(@NotNull Path path) {
        return this.getCustomFiles().getOrDefault(path, null);
    }

    @Nullable
    public final PaperCustomFile getPaperCustomFile(@NotNull Path path) {
        return (PaperCustomFile)this.getCustomFile(path);
    }

    @Nullable
    public final NbtCustomFile getNbtFile(@NotNull Path path) {
        return (NbtCustomFile)this.getCustomFile(path);
    }

    @Nullable
    public final LogCustomFile getLogFile(@NotNull Path path) {
        return (LogCustomFile)this.getCustomFile(path);
    }

    @Nullable
    public final YamlCustomFile getConfigurateFile(@NotNull Path path) {
        return (YamlCustomFile)this.getCustomFile(path);
    }

    @Nullable
    public final JaluCustomFile getJaluFile(@NotNull Path path) {
        return (JaluCustomFile)this.getCustomFile(path);
    }

    @Override
    @NotNull
    public final Map<Path, ICustomFile<? extends ICustomFile<?>>> getCustomFiles() {
        return Collections.unmodifiableMap(this.customFiles);
    }

    @Override
    @NotNull
    public final FileManager refresh(boolean save) {
        if (this.customFiles.isEmpty()) {
            return this;
        }
        ArrayList<Path> brokenFiles = new ArrayList<Path>();
        for (Map.Entry<Path, ICustomFile<ICustomFile<?>>> file : this.customFiles.entrySet()) {
            ICustomFile<ICustomFile<?>> value = file.getValue();
            if (value == null) continue;
            Path path = value.getPath();
            if (!Files.exists(path, new LinkOption[0])) {
                brokenFiles.add(path);
                continue;
            }
            if (save) {
                value.save();
                continue;
            }
            value.load();
        }
        if (!brokenFiles.isEmpty()) {
            brokenFiles.forEach(this.customFiles::remove);
        }
        return this;
    }
}

