/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.extension.defaults;

import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.LimitlessInternalArgument;
import dev.triumphteam.cmd.core.argument.UnknownInternalArgument;
import dev.triumphteam.cmd.core.extension.ValidationResult;
import dev.triumphteam.cmd.core.extension.argument.ArgumentValidator;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import org.jetbrains.annotations.NotNull;

public class DefaultArgumentValidator<S, ST>
implements ArgumentValidator<S, ST> {
    private final boolean validateOptionals;
    private final boolean validateLimitless;

    public DefaultArgumentValidator() {
        this(true, true);
    }

    public DefaultArgumentValidator(boolean validateOptionals, boolean validateLimitless) {
        this.validateOptionals = validateOptionals;
        this.validateLimitless = validateLimitless;
    }

    @Override
    @NotNull
    public ValidationResult<String> validate(@NotNull CommandMeta data, @NotNull InternalArgument<S, ST> argument, int position, int last) {
        if (this.validateOptionals && position != last && argument.isOptional()) {
            return this.invalid("Optional internalArgument is only allowed as the last internalArgument");
        }
        if (this.validateLimitless && position != last && argument instanceof LimitlessInternalArgument) {
            return this.invalid("Limitless internalArgument is only allowed as the last internalArgument");
        }
        if (argument instanceof UnknownInternalArgument) {
            return this.invalid("No internalArgument of type \"" + argument.getType().getName() + "\" registered");
        }
        return this.valid();
    }
}

