/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.extension.registry.Registry;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestionHolder;
import dev.triumphteam.cmd.core.suggestion.StaticSuggestion;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import dev.triumphteam.cmd.core.suggestion.SuggestionResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuggestionRegistry<S, ST>
implements Registry {
    private final Map<SuggestionKey, InternalSuggestion<S, ST>> suggestions = new HashMap<SuggestionKey, InternalSuggestion<S, ST>>();
    private final Map<Class<?>, InternalSuggestion<S, ST>> typeSuggestions = new HashMap();

    public void register(@NotNull SuggestionKey key, @NotNull InternalSuggestion<S, ST> suggestion) {
        this.suggestions.put(key, suggestion);
    }

    public void register(@NotNull SuggestionKey key, @NotNull SuggestionResolver.Simple<S> resolver, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.suggestions.put(key, new SimpleSuggestion<S, ST>(new SimpleSuggestionHolder.SimpleResolver<S, ST>(resolver, suggestionMapper), suggestionMapper, method));
    }

    public void registerRich(@NotNull SuggestionKey key, @NotNull SuggestionResolver<S, ST> resolver, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.suggestions.put(key, new SimpleSuggestion<S, ST>(new SimpleSuggestionHolder.RichResolver<S, ST>(resolver), suggestionMapper, method));
    }

    public void registerStatic(@NotNull SuggestionKey key, @NotNull List<String> suggestions, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.suggestions.put(key, new StaticSuggestion(new SimpleSuggestionHolder.SimpleStatic<ST>(suggestions, suggestionMapper.map(suggestions)), suggestionMapper, method));
    }

    public void registerStaticRich(@NotNull SuggestionKey key, @NotNull List<ST> suggestions, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.suggestions.put(key, new StaticSuggestion(new SimpleSuggestionHolder.RichStatic<ST>(suggestions, suggestionMapper.mapBackwards(suggestions)), suggestionMapper, method));
    }

    public void register(@NotNull Class<?> type, @NotNull SuggestionResolver.Simple<S> resolver, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.typeSuggestions.put(type, new SimpleSuggestion<S, ST>(new SimpleSuggestionHolder.SimpleResolver<S, ST>(resolver, suggestionMapper), suggestionMapper, method));
    }

    public void registerRich(@NotNull Class<?> type, @NotNull SuggestionResolver<S, ST> resolver, @NotNull SuggestionMethod method, @NotNull SuggestionMapper<ST> suggestionMapper) {
        this.typeSuggestions.put(type, new SimpleSuggestion<S, ST>(new SimpleSuggestionHolder.RichResolver<S, ST>(resolver), suggestionMapper, method));
    }

    @Contract(value="null -> null")
    @Nullable
    public InternalSuggestion<S, ST> getSuggestion(@Nullable SuggestionKey key) {
        if (key == null) {
            return null;
        }
        return this.suggestions.get(key);
    }

    @Nullable
    public InternalSuggestion<S, ST> getSuggestion(@NotNull Class<?> type) {
        return this.typeSuggestions.get(type);
    }
}

