/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.support;

import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import java.util.ArrayList;
import libs.org.bstats.bukkit.Metrics;
import libs.org.bstats.charts.SimplePie;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.CrateType;

public class MetricsWrapper {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final CrateManager crateManager;
    private final Metrics metrics;

    public MetricsWrapper(int serviceId) {
        this.metrics = new Metrics((Plugin)this.plugin, serviceId);
        this.crateManager = this.plugin.getCrateManager();
    }

    public void start() {
        if (this.metrics == null || !ConfigManager.getConfig().getProperty(ConfigKeys.toggle_metrics).booleanValue()) {
            return;
        }
        ArrayList<Crate> crates = new ArrayList<Crate>(this.crateManager.getCrates());
        crates.forEach(crate -> {
            CrateType type = crate.getCrateType();
            if (type == CrateType.menu) {
                return;
            }
            this.metrics.addCustomChart(new SimplePie("crate_types", type::getName));
        });
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }
}

