/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.suggestion;

import dev.triumphteam.cmd.core.extension.SuggestionMapper;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import dev.triumphteam.cmd.core.suggestion.SimpleSuggestionHolder;
import dev.triumphteam.cmd.core.suggestion.SuggestionContext;
import dev.triumphteam.cmd.core.suggestion.SuggestionMethod;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SimpleSuggestion<S, ST>
implements InternalSuggestion.Simple<S, ST> {
    private final SimpleSuggestionHolder<S, ST> holder;
    private final SuggestionMapper<ST> mapper;
    private final SuggestionMethod method;
    private final String extra;

    public SimpleSuggestion(@NotNull SimpleSuggestionHolder<S, ST> holder, @NotNull SuggestionMapper<ST> mapper, @NotNull SuggestionMethod method) {
        this(holder, mapper, method, "");
    }

    public SimpleSuggestion(@NotNull SimpleSuggestionHolder<S, ST> holder, @NotNull SuggestionMapper<ST> mapper, @NotNull SuggestionMethod method, @NotNull String extra) {
        this.holder = holder;
        this.mapper = mapper;
        this.method = method;
        this.extra = extra;
    }

    @Override
    @NotNull
    public List<ST> getSuggestions(@NotNull S sender, @NotNull String current, @NotNull List<String> arguments, @NotNull Map<String, String> argumentsMap) {
        return this.mapper.filter(current, this.holder.getSuggestions(SuggestionContext.of(current, sender, arguments, argumentsMap, this.extra)), this.method);
    }

    @Override
    @NotNull
    public InternalSuggestion<S, ST> copy(@NotNull SuggestionMethod method, @NotNull String extra) {
        return new SimpleSuggestion<S, ST>(this.holder, this.mapper, method, extra);
    }
}

