/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.numbers;

import ch.jalu.typeresolver.numbers.ValueRangeComparison;
import java.math.BigDecimal;

final class RangeComparisonHelper {
    private static final double LONG_MIN_AS_DOUBLE = -9.223372036854776E18;
    private static final double LONG_MAX_AS_DOUBLE = 9.223372036854776E18;

    private RangeComparisonHelper() {
    }

    static ValueRangeComparison compareToRange(int value, int min, int max) {
        if (value < min) {
            return ValueRangeComparison.BELOW_MINIMUM;
        }
        if (value > max) {
            return ValueRangeComparison.ABOVE_MAXIMUM;
        }
        return ValueRangeComparison.WITHIN_RANGE;
    }

    static ValueRangeComparison compareToRange(long value, long min, long max) {
        if (value < min) {
            return ValueRangeComparison.BELOW_MINIMUM;
        }
        if (value > max) {
            return ValueRangeComparison.ABOVE_MAXIMUM;
        }
        return ValueRangeComparison.WITHIN_RANGE;
    }

    static ValueRangeComparison compareToRange(double value, double min, double max) {
        if (value < min) {
            return ValueRangeComparison.BELOW_MINIMUM;
        }
        if (value > max) {
            return ValueRangeComparison.ABOVE_MAXIMUM;
        }
        return ValueRangeComparison.WITHIN_RANGE;
    }

    static ValueRangeComparison compareToRange(BigDecimal value, BigDecimal min, BigDecimal max) {
        if (value.compareTo(min) < 0) {
            return ValueRangeComparison.BELOW_MINIMUM;
        }
        if (value.compareTo(max) > 0) {
            return ValueRangeComparison.ABOVE_MAXIMUM;
        }
        return ValueRangeComparison.WITHIN_RANGE;
    }

    static ValueRangeComparison compareToLongRange(double value) {
        return ValueRangeComparison.getErrorForNonFiniteValue(value).orElseGet(() -> RangeComparisonHelper.compareToRange(value, -9.223372036854776E18, 9.223372036854776E18));
    }
}

