/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.typeimpl;

import ch.jalu.typeresolver.CommonTypeUtils;
import ch.jalu.typeresolver.TypeInfo;
import ch.jalu.typeresolver.typeimpl.ParameterizedTypeImpl;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class ParameterizedTypeBuilder {
    private final Class<?> rawType;
    @Nullable
    private final Type ownerType;
    private final TypeVariable<?>[] typeParameters;
    private final Type[] newTypeArguments;

    public ParameterizedTypeBuilder(ParameterizedType parameterizedType) {
        this.rawType = CommonTypeUtils.getRawType(parameterizedType);
        this.ownerType = parameterizedType.getOwnerType();
        this.typeParameters = this.rawType.getTypeParameters();
        this.newTypeArguments = (Type[])parameterizedType.getActualTypeArguments().clone();
    }

    private ParameterizedTypeBuilder(Class<?> rawType) {
        TypeVariable<Class<?>>[] typeParams = rawType.getTypeParameters();
        if (typeParams.length == 0) {
            throw new IllegalArgumentException("Class '" + rawType + "' has no type arguments");
        }
        this.rawType = rawType;
        this.ownerType = ParameterizedTypeBuilder.createOwnerType(rawType);
        this.typeParameters = typeParams;
        this.newTypeArguments = new Type[this.typeParameters.length];
    }

    public static ParameterizedTypeBuilder parameterizedTypeBuilder(Class<?> clazz) {
        return new ParameterizedTypeBuilder(clazz);
    }

    public static ParameterizedTypeImpl newCollectionType(Class<? extends Collection> baseType, @Nullable Type typeArgument) {
        return new ParameterizedTypeBuilder(baseType).withTypeArg(0, typeArgument).build();
    }

    public static ParameterizedTypeImpl newMapType(Class<? extends Map> baseType, @Nullable Type keyType, @Nullable Type valueType) {
        return new ParameterizedTypeBuilder(baseType).withTypeArg(0, keyType).withTypeArg(1, valueType).build();
    }

    public ParameterizedTypeBuilder withTypeArg(int typeParameterIndex, TypeInfo typeInfo) {
        return this.withTypeArg(typeParameterIndex, typeInfo.getType());
    }

    public ParameterizedTypeBuilder withTypeArg(int typeParameterIndex, @Nullable Type type) {
        if (typeParameterIndex < 0 || typeParameterIndex >= this.typeParameters.length) {
            throw new IllegalArgumentException("Type parameter index " + typeParameterIndex + " is out of bounds for " + this.rawType);
        }
        this.updateNewTypeArgumentEntry(typeParameterIndex, type);
        return this;
    }

    public ParameterizedTypeBuilder withTypeArg(String typeParameterName, TypeInfo typeInfo) {
        return this.withTypeArg(typeParameterName, typeInfo.getType());
    }

    public ParameterizedTypeBuilder withTypeArg(String typeParameterName, @Nullable Type type) {
        int index = this.findIndexOfMatchingTypeParam(p -> p.getName().equals(typeParameterName), () -> "No type parameter '" + typeParameterName + "' on " + this.rawType);
        this.updateNewTypeArgumentEntry(index, type);
        return this;
    }

    public ParameterizedTypeBuilder withTypeArg(TypeVariable<?> typeVariable, TypeInfo typeInfo) {
        return this.withTypeArg(typeVariable, typeInfo.getType());
    }

    public ParameterizedTypeBuilder withTypeArg(TypeVariable<?> typeVariable, @Nullable Type type) {
        Predicate<TypeVariable<?>> filter = curVar -> curVar.getName().equals(typeVariable.getName()) && curVar.getGenericDeclaration().equals(typeVariable.getGenericDeclaration());
        int index = this.findIndexOfMatchingTypeParam(filter, () -> "No type parameter matched '" + typeVariable + "' on " + this.rawType);
        this.updateNewTypeArgumentEntry(index, type);
        return this;
    }

    public ParameterizedTypeBuilder withTypeVariables() {
        TypeVariable<Class<?>>[] typeVariables = this.rawType.getTypeParameters();
        System.arraycopy(typeVariables, 0, this.newTypeArguments, 0, typeVariables.length);
        return this;
    }

    public ParameterizedTypeImpl build() {
        for (int i = 0; i < this.typeParameters.length; ++i) {
            if (this.newTypeArguments[i] != null) continue;
            String typeVariableName = this.typeParameters[i].getName();
            throw new IllegalStateException("Type parameter '" + typeVariableName + "' at index " + i + " has not been set");
        }
        return new ParameterizedTypeImpl(this.rawType, this.ownerType, this.newTypeArguments);
    }

    @Nullable
    public static Type createOwnerType(Class<?> rawType) {
        Class<?> directDeclaringClass = rawType.getDeclaringClass();
        if (directDeclaringClass == null || Modifier.isStatic(rawType.getModifiers())) {
            return directDeclaringClass;
        }
        return ParameterizedTypeBuilder.createOwnerTypeHierarchyForDeclaredNonStaticClass(rawType);
    }

    private static Type createOwnerTypeHierarchyForDeclaredNonStaticClass(Class<?> rawType) {
        ArrayList<Class<?>> declaringClasses = ParameterizedTypeBuilder.collectRelevantDeclaringClasses(rawType);
        Type lastOwnerType = null;
        for (int i = declaringClasses.size() - 1; i >= 0; --i) {
            Class ownerType = (Class)declaringClasses.get(i);
            if (lastOwnerType == null) {
                Type[] typeParams = ownerType.getTypeParameters();
                if (typeParams.length <= 0) continue;
                lastOwnerType = new ParameterizedTypeImpl(ownerType, ownerType.getDeclaringClass(), typeParams);
                continue;
            }
            lastOwnerType = new ParameterizedTypeImpl(ownerType, lastOwnerType, ownerType.getTypeParameters());
        }
        return lastOwnerType == null ? rawType.getDeclaringClass() : lastOwnerType;
    }

    private static ArrayList<Class<?>> collectRelevantDeclaringClasses(Class<?> rawType) {
        ArrayList declaringClasses = new ArrayList();
        for (Class<?> currentClass = rawType.getDeclaringClass(); currentClass != null; currentClass = currentClass.getDeclaringClass()) {
            declaringClasses.add(currentClass);
            if (Modifier.isStatic(currentClass.getModifiers())) break;
        }
        return declaringClasses;
    }

    private void updateNewTypeArgumentEntry(int index, @Nullable Type type) {
        this.newTypeArguments[index] = type == null ? this.typeParameters[index] : type;
    }

    private int findIndexOfMatchingTypeParam(Predicate<TypeVariable<?>> filter, Supplier<String> exceptionMessage) {
        int index = 0;
        for (TypeVariable<?> typeParam : this.typeParameters) {
            if (filter.test(typeParam)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException(exceptionMessage.get());
    }
}

