/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.builders.gui;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.beans.inventories.ItemPlacement;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.tasks.menus.CrateMainMenu;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.api.builders.gui.types.BaseGui;
import java.text.NumberFormat;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBuilder {
    protected final Player player;
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final ComponentLogger logger = this.plugin.getComponentLogger();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final BukkitUserManager userManager = this.plugin.getUserManager();
    protected final InventoryManager inventoryManager = this.plugin.getInventoryManager();
    protected final SettingsManager config = ConfigManager.getConfig();

    public InventoryBuilder(@NotNull Player player) {
        this.player = player;
    }

    public void addMenuButton(@NotNull Player player, @NotNull Crate crate, @NotNull BaseGui gui) {
        if (!this.config.getProperty(ConfigKeys.enable_crate_menu).booleanValue()) {
            return;
        }
        ItemPlacement placement = this.config.getProperty(ConfigKeys.menu_button_placement);
        int row = placement.getRow();
        int column = placement.getColumn();
        int rows = gui.getRows();
        int safeRow = Math.min(row == -1 ? rows : row, rows);
        gui.setItem(safeRow, column, new GuiItem(this.inventoryManager.getMenuButton(player), action -> {
            if (this.config.getProperty(ConfigKeys.menu_button_override).booleanValue()) {
                List<String> commands = this.config.getProperty(ConfigKeys.menu_button_command_list);
                if (!commands.isEmpty()) {
                    commands.forEach(value -> {
                        String command = value.replaceAll("%player%", Matcher.quoteReplacement(player.getName())).replaceAll("%crate%", Matcher.quoteReplacement(crate.getFileName()));
                        MiscUtils.sendCommand(command);
                    });
                    return;
                }
                if (MiscUtils.isLogging()) {
                    this.logger.warn("The property {} is empty, so no commands were run.", (Object)ConfigKeys.menu_button_command_list.getPath());
                }
                return;
            }
            crate.playSound(player, player.getLocation(), "click-sound", "ui.button.click", Sound.Source.MASTER);
            new CrateMainMenu(player, this.config.getProperty(ConfigKeys.inventory_name), this.config.getProperty(ConfigKeys.inventory_rows)).open();
        }));
    }

    public final String parse(@NotNull Player player, @NotNull String title) {
        return Plugins.placeholder_api.isEnabled() ? PlaceholderAPI.setPlaceholders((Player)player, (String)title) : title;
    }

    public final String getCrates(@NotNull String option) {
        if (option.isEmpty()) {
            return "";
        }
        UUID uuid = this.player.getUniqueId();
        NumberFormat instance = NumberFormat.getInstance();
        String clone = option;
        for (Crate crate : this.crateManager.getUsableCrates()) {
            String fileName = crate.getFileName();
            String lowerCase = fileName.toLowerCase();
            int virtual = this.userManager.getVirtualKeys(uuid, fileName);
            int physical = this.userManager.getPhysicalKeys(uuid, fileName);
            int total = virtual + physical;
            int opened = this.userManager.getCrateOpened(uuid, fileName);
            clone = clone.replaceAll("%" + lowerCase + "%", instance.format(virtual)).replaceAll("%" + lowerCase + "_physical%", instance.format(physical)).replaceAll("%" + lowerCase + "_total%", instance.format(total)).replaceAll("%" + lowerCase + "_opened%", instance.format(opened)).replaceAll("%" + lowerCase + "_raw%", String.valueOf(virtual)).replaceAll("%" + lowerCase + "_raw_physical%", String.valueOf(physical)).replaceAll("%" + lowerCase + "_raw_total%", String.valueOf(total)).replaceAll("%" + lowerCase + "_raw_opened%", String.valueOf(opened));
        }
        return clone;
    }
}

