/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.enums.other.keys;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.exceptions.FusionException;
import com.ryderbelserion.fusion.core.files.types.LogCustomFile;
import com.ryderbelserion.fusion.paper.files.FileManager;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.nio.file.Path;
import java.util.ArrayList;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FileKeys {
    respin_gui(FileType.PAPER, "respin-gui.yml", "guis"),
    crate_log(FileType.LOG, "crates.log", "logs"),
    key_log(FileType.LOG, "keys.log", "logs"),
    locations(FileType.PAPER, "locations.yml"),
    data(FileType.PAPER, "data.yml");

    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final FileManager fileManager = this.plugin.getFileManager();
    private final Path path;
    private final FileType fileType;
    private final Path location;
    private final Path folder;

    private FileKeys(@NotNull FileType fileType, String fileName, String folder) {
        this.path = this.plugin.getDataPath();
        this.folder = this.path.resolve(folder);
        this.location = this.folder.resolve(fileName);
        this.fileType = fileType;
    }

    private FileKeys(FileType fileType, String fileName) {
        this.folder = this.path = this.plugin.getDataPath();
        this.location = this.folder.resolve(fileName);
        this.fileType = fileType;
    }

    @NotNull
    public final YamlConfiguration getConfiguration() {
        return (YamlConfiguration)this.getPaperCustomFile().getConfiguration();
    }

    @NotNull
    public final PaperCustomFile getPaperCustomFile() {
        @Nullable PaperCustomFile customFile = this.fileManager.getPaperCustomFile(this.location);
        if (customFile == null) {
            throw new FusionException("Could not find custom file for " + String.valueOf(this.location));
        }
        return customFile;
    }

    @NotNull
    public final LogCustomFile getLogCustomFile() {
        @Nullable LogCustomFile customFile = (LogCustomFile)this.fileManager.getCustomFile(this.location);
        if (customFile == null) {
            throw new FusionException("Could not find custom file for " + String.valueOf(this.location));
        }
        return customFile;
    }

    @NotNull
    public final FileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final Path getPath() {
        return this.location;
    }

    public void save(@NotNull String content, @NotNull ArrayList<FileAction> actions) {
        this.fileManager.saveFile(this.location, actions, content);
    }

    public void save() {
        this.fileManager.saveFile(this.location);
    }
}

