/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types;

import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class MojangMappedMigratorMultiple
extends ICrateMigrator {
    public MojangMappedMigratorMultiple(CommandSender sender) {
        super(sender, MigrationType.MOJANG_MAPPED_ALL);
    }

    @Override
    public void run() {
        Collection<ICustomFile<ICustomFile<?>>> customFiles = this.fileManager.getCustomFiles().values();
        final ArrayList failed = new ArrayList();
        final ArrayList success = new ArrayList();
        customFiles.forEach(key -> {
            try {
                if (key.isStatic() || !key.isLoaded() || key.getFileType() != FileType.PAPER) {
                    return;
                }
                PaperCustomFile customFile = (PaperCustomFile)key;
                this.migrate(customFile, "");
                success.add("<green>\u2937 " + customFile.getFileName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + key.getFileName());
            }
        });
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        this.sendMessage((List<String>)new ArrayList<String>(failedCrates + convertedCrates){
            {
                super(arg0);
                this.addAll(failed);
                this.addAll(success);
            }
        }, convertedCrates, failedCrates);
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

