/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.listeners;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.crates.BrokeLocation;
import com.badbones69.crazycrates.paper.api.objects.crates.CrateLocation;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import java.util.ArrayList;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;

public class BrokeLocationsListener
implements Listener {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        if (this.crateManager.getBrokeLocations().isEmpty()) {
            return;
        }
        int fixedAmount = 0;
        ArrayList<BrokeLocation> fixedWorlds = new ArrayList<BrokeLocation>();
        for (BrokeLocation brokeLocation : this.crateManager.getBrokeLocations()) {
            Crate crate;
            Location location = brokeLocation.getLocation();
            World world = location.getWorld();
            if (world == null || (crate = brokeLocation.getCrate()) == null) continue;
            CrateLocation crateLocation = new CrateLocation(brokeLocation.getLocationName(), crate, location);
            this.crateManager.addLocation(crateLocation);
            HologramManager manager = this.crateManager.getHolograms();
            if (manager != null && crate.getHologram().isEnabled()) {
                manager.createHologram(location, crate, crateLocation.getID());
            }
            fixedWorlds.add(brokeLocation);
            ++fixedAmount;
        }
        this.crateManager.removeBrokeLocation(fixedWorlds);
        if (MiscUtils.isLogging()) {
            this.logger.warn("Fixed {} broken crate locations.", (Object)fixedAmount);
            if (this.crateManager.getBrokeLocations().isEmpty()) {
                this.logger.warn("All broken crate locations have been fixed.");
            }
        }
    }
}

