/*
 * Decompiled with CFR 0.152.
 */
package com.ryderbelserion.fusion.core.api.utils;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class AdvUtils {
    @NotNull
    public static Component parse(@NotNull String message, TagResolver ... tags) {
        if (message.isEmpty()) {
            return Component.empty();
        }
        return MiniMessage.miniMessage().deserialize(message, tags).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    @NotNull
    public static Component parse(@NotNull String message) {
        return AdvUtils.parse(message, TagResolver.empty());
    }

    @NotNull
    public static String fromComponent(@NotNull Component component) {
        return AdvUtils.fromComponent(component, false);
    }

    @NotNull
    public static String fromComponent(@NotNull Component component, boolean isMessage) {
        String value = (String)MiniMessage.miniMessage().serialize(component);
        return isMessage ? value.replace("\\<", "<") : value;
    }

    @NotNull
    public static List<String> fromComponent(@NotNull List<Component> components) {
        ArrayList<String> keys = new ArrayList<String>(components.size());
        components.forEach(component -> keys.add(AdvUtils.fromComponent(component)));
        return keys;
    }

    @NotNull
    public static Component toComponent(@NotNull String component) {
        return LegacyComponentSerializer.legacyAmpersand().deserialize(component.replace("\u00a7", "&"));
    }

    @NotNull
    public static List<Component> toComponent(final @NotNull List<String> lore) {
        return new ArrayList<Component>(lore.size()){
            {
                super(arg0);
                lore.forEach((? super T line) -> this.add(AdvUtils.toComponent(line)));
            }
        };
    }

    @NotNull
    public static String convert(@NotNull String component) {
        return AdvUtils.convert(component, false);
    }

    @NotNull
    public static List<String> convert(@NotNull List<String> components) {
        return AdvUtils.convert(components, false);
    }

    @NotNull
    public static List<String> convert(final @NotNull List<String> components, final boolean isMessage) {
        return new ArrayList<String>(components.size()){
            {
                super(arg0);
                components.forEach((? super T line) -> this.add(AdvUtils.convert(line, isMessage)));
            }
        };
    }

    @NotNull
    public static String convert(@NotNull String component, boolean isMessage) {
        return AdvUtils.fromComponent(AdvUtils.toComponent(component), isMessage);
    }
}

