/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument;

import dev.triumphteam.cmd.core.argument.CollectionInternalArgument;
import dev.triumphteam.cmd.core.argument.InternalArgument;
import dev.triumphteam.cmd.core.argument.StringInternalArgument;
import dev.triumphteam.cmd.core.command.ArgumentInput;
import dev.triumphteam.cmd.core.extension.InternalArgumentResult;
import dev.triumphteam.cmd.core.extension.meta.CommandMeta;
import dev.triumphteam.cmd.core.suggestion.InternalSuggestion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplitStringInternalArgument<S, ST>
extends StringInternalArgument<S, ST> {
    private final String regex;
    private final InternalArgument<S, ST> internalArgument;
    private final Class<?> collectionType;

    public SplitStringInternalArgument(@NotNull CommandMeta meta, @NotNull String name, @NotNull String description, @NotNull String regex, @NotNull InternalArgument<S, ST> internalArgument, @NotNull Class<?> collectionType, @NotNull InternalSuggestion<S, ST> suggestion, @Nullable String defaultValue, boolean optional) {
        super(meta, name, description, String.class, suggestion, defaultValue, optional);
        this.regex = regex;
        this.internalArgument = internalArgument;
        this.collectionType = collectionType;
    }

    @Override
    @NotNull
    public InternalArgumentResult resolve(@NotNull S sender, @NotNull ArgumentInput input) {
        return CollectionInternalArgument.resolveCollection(sender, this.internalArgument, Arrays.asList(input.getInput().split(this.regex)), this.collectionType);
    }

    @NotNull
    public List<String> suggestions(@NotNull S sender, @NotNull Deque<String> arguments) {
        String peek = arguments.peekLast();
        String last = peek == null ? "" : peek;
        List<String> split = Arrays.asList(last.split(this.regex));
        if (split.isEmpty()) {
            return Collections.emptyList();
        }
        String current = last.endsWith(this.regex) ? "" : split.get(split.size() - 1);
        String joined = String.join((CharSequence)this.regex, current.isEmpty() ? split : split.subList(0, split.size() - 1));
        String map = joined.isEmpty() ? "" : joined + this.regex;
        InternalSuggestion suggestion = this.getSuggestion();
        if (!(suggestion instanceof InternalSuggestion.Simple)) {
            return Collections.emptyList();
        }
        return ((InternalSuggestion.Simple)suggestion).getSuggestions(sender, current, new ArrayList<String>(arguments), Collections.emptyMap()).stream().map(it -> map + it).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String toString() {
        return "SplitArgument{super=" + super.toString() + "}";
    }
}

