/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.util;

import dev.triumphteam.cmd.core.exceptions.CommandRegistrationException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public final class EnumUtils {
    private static final Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> ENUM_CONSTANT_CACHE = new WeakHashMap();

    private EnumUtils() {
        throw new AssertionError((Object)"Util must not be initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static @NotNull Map<String, @NotNull WeakReference<? extends Enum<?>>> getEnumConstants(@NotNull Class<? extends Enum<?>> enumClass) {
        Map<Class<? extends Enum<?>>, Map<String, WeakReference<? extends Enum<?>>>> map = ENUM_CONSTANT_CACHE;
        synchronized (map) {
            Map<String, WeakReference<? extends Enum<?>>> constants = ENUM_CONSTANT_CACHE.get(enumClass);
            if (constants == null) {
                constants = EnumUtils.populateCache(enumClass);
            }
            return constants;
        }
    }

    @NotNull
    public static Map<String, WeakReference<? extends Enum<?>>> populateCache(@NotNull Class<? extends Enum<?>> enumClass) {
        HashMap result = new HashMap();
        for (Enum<?> enumInstance : enumClass.getEnumConstants()) {
            String name = enumInstance.name().toUpperCase();
            if (result.containsKey(name)) {
                throw new CommandRegistrationException("Provided enum \"" + enumClass.getSimpleName() + "\" has multiple values with the name \"" + name + "\"");
            }
            result.put(name, new WeakReference(enumInstance));
        }
        ENUM_CONSTANT_CACHE.put(enumClass, result);
        return result;
    }
}

