/*
 * Decompiled with CFR 0.152.
 */
package ch.jalu.typeresolver.array;

import ch.jalu.typeresolver.array.ArrayTypeProperties;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Objects;

public class GenericArrayTypeProperties
implements ArrayTypeProperties {
    private final Type componentType;
    private final int dimension;

    public GenericArrayTypeProperties(GenericArrayType genericArrayType) {
        Type componentType = genericArrayType;
        int dimension = 0;
        while (componentType instanceof GenericArrayType) {
            componentType = componentType.getGenericComponentType();
            ++dimension;
        }
        this.componentType = componentType;
        this.dimension = dimension;
    }

    public GenericArrayTypeProperties(Type componentType, int dimension) {
        this.componentType = componentType;
        this.dimension = dimension;
    }

    @Override
    public Type getComponentType() {
        return this.componentType;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GenericArrayTypeProperties) {
            GenericArrayTypeProperties that = (GenericArrayTypeProperties)obj;
            return this.dimension == that.dimension && Objects.equals(this.componentType, that.componentType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.componentType);
    }

    public String toString() {
        return "GenericArrayTypeProperties[componentType='" + this.componentType + "', dimension=" + this.dimension + "]";
    }
}

