/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper;

import com.badbones69.crazycrates.core.Server;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.commands.CommandManager;
import com.badbones69.crazycrates.paper.listeners.BrokeLocationsListener;
import com.badbones69.crazycrates.paper.listeners.CrateControlListener;
import com.badbones69.crazycrates.paper.listeners.MiscListener;
import com.badbones69.crazycrates.paper.listeners.crates.CrateInteractListener;
import com.badbones69.crazycrates.paper.listeners.crates.CrateOpenListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.CosmicCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.MobileCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.QuadCrateListener;
import com.badbones69.crazycrates.paper.listeners.crates.types.WarCrateListener;
import com.badbones69.crazycrates.paper.listeners.items.PaperInteractListener;
import com.badbones69.crazycrates.paper.listeners.other.EntityDamageListener;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.managers.InventoryManager;
import com.badbones69.crazycrates.paper.support.MetricsWrapper;
import com.badbones69.crazycrates.paper.support.holograms.HologramManager;
import com.badbones69.crazycrates.paper.support.placeholders.PlaceholderAPISupport;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.core.api.enums.FileAction;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.paper.FusionPaper;
import com.ryderbelserion.fusion.paper.files.FileManager;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class CrazyCrates
extends JavaPlugin {
    private final Timer timer;
    private final long startTime = System.nanoTime();
    private InventoryManager inventoryManager;
    private BukkitUserManager userManager;
    private CrateManager crateManager;
    private FusionPaper fusion;
    private Server instance;
    private MetricsWrapper metrics;
    private FileManager fileManager;

    public static CrazyCrates getPlugin() {
        return (CrazyCrates)JavaPlugin.getPlugin(CrazyCrates.class);
    }

    public CrazyCrates() {
        this.timer = new Timer();
    }

    public void onEnable() {
        this.fusion = new FusionPaper(this.getComponentLogger(), this.getDataPath());
        this.fusion.enable(this);
        this.fileManager = this.fusion.getFileManager();
        Path path = this.getDataPath();
        this.instance = new Server(path);
        this.instance.apply();
        ((FileManager)((FileManager)((FileManager)((FileManager)((FileManager)this.fileManager.refresh(false).addFile(path.resolve("locations.yml"), FileType.PAPER, (List)List.of(FileAction.STATIC_FILE), (UnaryOperator)null)).addFile(path.resolve("data.yml"), FileType.PAPER, (List)List.of(FileAction.STATIC_FILE), (UnaryOperator)null)).addFile(path.resolve("guis").resolve("respin-gui.yml"), FileType.PAPER, (List)List.of(FileAction.STATIC_FILE), (UnaryOperator)null)).addFolder(path.resolve("logs"), FileType.LOG, (List)List.of(FileAction.EXTRACT_FOLDER, FileAction.STATIC_FILE), (UnaryOperator)null)).addFolder(path.resolve("crates"), FileType.PAPER, (List)List.of(FileAction.EXTRACT_FOLDER), (UnaryOperator)null)).addFolder(path.resolve("schematics"), FileType.NBT, (List)List.of(FileAction.EXTRACT_FOLDER), (UnaryOperator)null);
        MiscUtils.janitor();
        MiscUtils.save();
        MiscUtils.registerPermissions();
        this.inventoryManager = new InventoryManager();
        this.crateManager = new CrateManager();
        this.userManager = new BukkitUserManager();
        this.instance.setUserManager(this.userManager);
        this.crateManager.loadHolograms();
        this.inventoryManager.loadButtons();
        this.crateManager.loadCrates();
        if (ConfigManager.getConfig().getProperty(ConfigKeys.toggle_metrics).booleanValue()) {
            this.metrics = new MetricsWrapper(4514);
            this.metrics.start();
        }
        CommandManager.load();
        PluginManager manager = this.getServer().getPluginManager();
        List.of(new BrokeLocationsListener(), new EntityDamageListener(), new MobileCrateListener(), new CosmicCrateListener(), new QuadCrateListener(), new WarCrateListener(), new MiscListener(), new CrateInteractListener(), new CrateControlListener(), new CrateOpenListener(), new PaperInteractListener()).forEach(listener -> manager.registerEvents(listener, (Plugin)this));
        this.crateManager.loadCustomItems();
        if (Plugins.placeholder_api.isEnabled()) {
            if (MiscUtils.isLogging()) {
                this.getComponentLogger().info("PlaceholderAPI support is enabled!");
            }
            new PlaceholderAPISupport().register();
        }
        if (MiscUtils.isLogging()) {
            ComponentLogger logger = this.getComponentLogger();
            for (Plugins value : Plugins.values()) {
                if (value.isEnabled()) {
                    logger.info(AdvUtils.parse("<bold><gold>" + value.getName() + " <green>FOUND"));
                    continue;
                }
                logger.info(AdvUtils.parse("<bold><gold>" + value.getName() + " <red>NOT FOUND"));
            }
            logger.info("Done ({})!", (Object)String.format(Locale.ROOT, "%.3fs", (double)(System.nanoTime() - this.startTime) / 1.0E9));
        }
    }

    public void onDisable() {
        org.bukkit.Server server = this.getServer();
        server.getGlobalRegionScheduler().cancelTasks((Plugin)this);
        server.getAsyncScheduler().cancelTasks((Plugin)this);
        this.timer.cancel();
        if (this.crateManager != null) {
            this.crateManager.purgeRewards();
            HologramManager holograms = this.crateManager.getHolograms();
            if (holograms != null) {
                holograms.purge(true);
            }
        }
        if (this.instance != null) {
            this.instance.disable();
        }
        if (this.fusion != null) {
            this.fusion.disable();
        }
        MiscUtils.janitor();
    }

    public final InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public final BukkitUserManager getUserManager() {
        return this.userManager;
    }

    public final CrateManager getCrateManager() {
        return this.crateManager;
    }

    public final FileManager getFileManager() {
        return this.fileManager;
    }

    public final MetricsWrapper getMetrics() {
        return this.metrics;
    }

    public final FusionPaper getFusion() {
        return this.fusion;
    }

    public final Server getInstance() {
        return this.instance;
    }

    public final Timer getTimer() {
        return this.timer;
    }
}

