/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.builders.types.features;

import com.badbones69.crazycrates.paper.api.builders.gui.StaticInventoryBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.Gui;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiFiller;
import com.ryderbelserion.fusion.paper.api.builders.gui.interfaces.GuiItem;
import com.ryderbelserion.fusion.paper.api.enums.Scheduler;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CrateSpinMenu
extends StaticInventoryBuilder {
    private final GuiSettings settings;
    private final Player player = this.getPlayer();
    private final Crate crate = this.getCrate();
    private final Gui gui = this.getGui();

    public CrateSpinMenu(@NotNull Player player, @NotNull GuiSettings settings) {
        super(player, settings.getCrate(), settings.getTitle(), settings.getRows());
        this.settings = settings;
    }

    @Override
    public void open() {
        if (this.crate == null) {
            return;
        }
        if (this.settings.isFillerToggled()) {
            GuiItem item = this.settings.getFillerStack();
            GuiFiller guiFiller = this.gui.getFiller();
            switch (this.settings.getFillerType()) {
                case FILL: {
                    guiFiller.fill(item);
                    break;
                }
                case FILL_BORDER: {
                    guiFiller.fillBorder(item);
                    break;
                }
                case FILL_TOP: {
                    guiFiller.fillTop(item);
                    break;
                }
                case FILL_SIDE: {
                    guiFiller.fillSide(GuiFiller.Side.BOTH, List.of(item));
                    break;
                }
                case FILL_BOTTOM: {
                    guiFiller.fillBottom(item);
                }
            }
        }
        final UUID uuid = this.player.getUniqueId();
        final String fileName = this.crate.getFileName();
        this.settings.getButtons().forEach((slot, button) -> this.gui.setItem((int)slot, button.getGuiItem()));
        this.gui.setOpenGuiAction(action -> this.userManager.addRespinPrize(uuid, fileName, this.settings.getPrize().getSectionName()));
        this.gui.setCloseGuiAction(action -> {
            new FoliaScheduler(this.plugin, Scheduler.global_scheduler){

                @Override
                public void run() {
                    if (CrateSpinMenu.this.userManager.hasRespinPrize(uuid, fileName)) {
                        Messages.crate_prize_respin_not_claimed.sendMessage((CommandSender)CrateSpinMenu.this.player, Map.of("{crate_pretty}", CrateSpinMenu.this.crate.getCrateName(), "{crate}", fileName, "{prize}", CrateSpinMenu.this.userManager.getRespinPrize(uuid, fileName)));
                    }
                }
            }.runDelayed(20L);
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            this.crateManager.removeCrateTask(this.player);
            this.crateManager.endCrate(this.player);
        });
        this.gui.setItem(this.settings.getSlot(), new GuiItem(this.settings.getPrize().getDisplayItem(this.player, this.crate)));
        this.gui.open(this.player);
    }
}

