/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.api.objects;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.core.config.impl.ConfigKeys;
import com.badbones69.crazycrates.core.config.impl.messages.CrateKeys;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.LegacyItemBuilder;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.enums.other.keys.ItemKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Tier;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.core.api.utils.AdvUtils;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import com.ryderbelserion.fusion.paper.api.builders.items.ItemBuilder;
import com.ryderbelserion.fusion.paper.utils.ColorUtils;
import com.ryderbelserion.fusion.paper.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Color;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Prize {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final ComponentLogger logger = this.plugin.getComponentLogger();
    private final SettingsManager config = ConfigManager.getConfig();
    private final ConfigurationSection section;
    private final List<LegacyItemBuilder> builders;
    private final List<ItemBuilder> items;
    private final List<String> commands;
    private final List<String> messages;
    private final String sectionName;
    private final String prizeName;
    private List<String> permissions = new ArrayList<String>();
    private LegacyItemBuilder displayItem = new LegacyItemBuilder(this.plugin);
    private boolean firework = false;
    private String crateName = "";
    private double weight = -1.0;
    private int maxPulls;
    private List<Tier> tiers = new ArrayList<Tier>();
    private Prize alternativePrize;
    private boolean broadcastToggle = false;
    private List<String> broadcastMessages = new ArrayList<String>();
    private String broadcastPermission = "";
    private List<ItemStack> editorItems = new ArrayList<ItemStack>();

    public Prize(@NotNull ConfigurationSection section, @NotNull List<ItemStack> editorItems, @NotNull List<Tier> tierPrizes, @NotNull String crateName, @Nullable Prize alternativePrize) {
        this.section = section;
        this.sectionName = section.getName();
        this.crateName = crateName;
        if (this.config.getProperty(ConfigKeys.use_different_items_layout).booleanValue() && !this.section.isList("Items")) {
            this.items = com.badbones69.crazycrates.paper.utils.ItemUtils.convertConfigurationSection(this.section.getConfigurationSection("Items"));
            this.builders = new ArrayList<LegacyItemBuilder>();
        } else {
            this.builders = com.badbones69.crazycrates.paper.utils.ItemUtils.convertStringList(this.section.getStringList("Items"), this.sectionName);
            this.items = new ArrayList<ItemBuilder>();
        }
        this.maxPulls = section.getInt("Settings.Max-Pulls", -1);
        this.tiers = tierPrizes;
        this.alternativePrize = alternativePrize;
        this.prizeName = section.getString("DisplayName", "");
        this.weight = section.getDouble("Weight", -1.0);
        this.firework = section.getBoolean("Firework", false);
        this.messages = section.getStringList("Messages");
        this.commands = section.getStringList("Commands");
        this.permissions = section.getStringList("BlackListed-Permissions");
        if (!this.permissions.isEmpty()) {
            this.permissions.replaceAll(String::toLowerCase);
        }
        this.broadcastToggle = section.getBoolean("Settings.Broadcast.Toggle", false);
        this.broadcastMessages = section.getStringList("Settings.Broadcast.Messages");
        this.broadcastPermission = section.getString("Settings.Broadcast.Permission", "");
        if (this.broadcastToggle && !this.broadcastPermission.isEmpty()) {
            MiscUtils.registerPermission(this.broadcastPermission, "Hides the broadcast message for prize: " + this.prizeName + " if a player has this permission", false);
        } else if (!this.broadcastToggle && !this.broadcastPermission.isEmpty()) {
            MiscUtils.unregisterPermission(this.broadcastPermission);
        }
        this.displayItem = this.display();
        this.editorItems = editorItems;
    }

    public Prize(@NotNull String prizeName, @NotNull String sectionName, @NotNull ConfigurationSection section) {
        this.prizeName = prizeName;
        this.messages = section.getStringList("Messages");
        this.commands = section.getStringList("Commands");
        this.sectionName = sectionName;
        this.section = section;
        if (this.config.getProperty(ConfigKeys.use_different_items_layout).booleanValue() && !this.section.isList("Items")) {
            this.items = com.badbones69.crazycrates.paper.utils.ItemUtils.convertConfigurationSection(this.section.getConfigurationSection("Items"));
            this.builders = new ArrayList<LegacyItemBuilder>();
        } else {
            this.builders = com.badbones69.crazycrates.paper.utils.ItemUtils.convertStringList(this.section.getStringList("Items"), this.sectionName);
            this.items = new ArrayList<ItemBuilder>();
        }
    }

    @NotNull
    public final String getPrizeName() {
        return this.prizeName.isEmpty() ? "<lang:" + this.displayItem.getType().getItemTranslationKey() + ">" : this.prizeName;
    }

    @NotNull
    public final String getStrippedName() {
        return PlainTextComponentSerializer.plainText().serialize(AdvUtils.parse(this.getPrizeName()));
    }

    @NotNull
    public final String getSectionName() {
        return this.sectionName;
    }

    @NotNull
    public final ItemStack getDisplayItem(@NotNull Crate crate) {
        return this.getDisplayItem(null, crate);
    }

    @NotNull
    public final ItemStack getDisplayItem(@Nullable Player player, @NotNull Crate crate) {
        int pulls = PrizeManager.getCurrentPulls(this, crate);
        int maxPulls = this.getMaxPulls();
        String amount = String.valueOf(pulls);
        ArrayList<String> lore = new ArrayList<String>();
        boolean isPapiEnabled = Plugins.placeholder_api.isEnabled();
        String displayName = this.displayItem.getDisplayName();
        this.displayItem.setDisplayName(player != null && isPapiEnabled ? PlaceholderAPI.setPlaceholders((Player)player, (String)displayName) : displayName);
        if (this.section.contains("DisplayLore") && !this.section.contains("Lore")) {
            this.section.getStringList("DisplayLore").forEach(line -> lore.add(player != null && isPapiEnabled ? PlaceholderAPI.setPlaceholders((Player)player, (String)line) : line));
        }
        if (this.section.contains("Lore")) {
            if (MiscUtils.isLogging()) {
                List.of("Deprecated usage of Lore in your Prize " + this.sectionName + " in " + this.crateName + ".yml, please change Lore to DisplayLore", "Lore will be removed in the next major version of Minecraft in favor of DisplayLore", "You can turn my nagging off in config.yml, verbose_logging: true -> false").forEach(arg_0 -> ((ComponentLogger)this.logger).warn(arg_0));
            }
            this.section.getStringList("Lore").forEach(line -> lore.add(player != null && isPapiEnabled ? PlaceholderAPI.setPlaceholders((Player)player, (String)line) : line));
        }
        if (maxPulls != 0 && pulls != 0 && pulls >= maxPulls) {
            if (player != null) {
                line = Messages.crate_prize_max_pulls.getMessage((CommandSender)player);
                if (!line.isEmpty()) {
                    String variable = line.replaceAll("\\{maxpulls}", String.valueOf(maxPulls)).replaceAll("\\{pulls}", amount);
                    lore.add(isPapiEnabled ? PlaceholderAPI.setPlaceholders((Player)player, (String)variable) : variable);
                }
            } else {
                line = ConfigManager.getMessages().getProperty(CrateKeys.crate_prize_max_pulls);
                if (!line.isEmpty()) {
                    lore.add(line.replaceAll("\\{maxpulls}", String.valueOf(maxPulls)).replaceAll("\\{pulls}", amount));
                }
            }
        }
        this.displayItem.setDisplayLore(lore);
        if (player != null) {
            this.displayItem.setPlayer(player);
        }
        String weight = StringUtils.format(crate.getChance(this.getWeight()));
        ((LegacyItemBuilder)((LegacyItemBuilder)this.displayItem.addLorePlaceholder("%chance%", weight)).addLorePlaceholder("%maxpulls%", String.valueOf(maxPulls))).addLorePlaceholder("%pulls%", amount);
        ((LegacyItemBuilder)((LegacyItemBuilder)this.displayItem.addNamePlaceholder("%chance%", weight)).addNamePlaceholder("%maxpulls%", String.valueOf(maxPulls))).addNamePlaceholder("%pulls%", amount);
        return ((LegacyItemBuilder)this.displayItem.setPersistentString(ItemKeys.crate_prize.getNamespacedKey(), this.sectionName)).asItemStack();
    }

    @NotNull
    public final List<Tier> getTiers() {
        return this.tiers;
    }

    @NotNull
    public final List<String> getMessages() {
        return this.messages;
    }

    @NotNull
    public final List<String> getCommands() {
        return this.commands;
    }

    @NotNull
    public final List<LegacyItemBuilder> getItemBuilders() {
        return this.builders;
    }

    @NotNull
    public final List<ItemBuilder> getItems() {
        return this.items;
    }

    public final boolean isItemsEmpty() {
        return this.config.getProperty(ConfigKeys.use_different_items_layout) != false && this.getItems().isEmpty() || this.getItemBuilders().isEmpty();
    }

    @NotNull
    public final String getCrateName() {
        return this.crateName;
    }

    public final double getWeight() {
        if (this.weight == -1.0 && MiscUtils.isLogging()) {
            this.logger.warn("Cannot fetch the weight as the option is not present for this prize: {} in the crate: {}", (Object)this.prizeName, (Object)this.crateName);
        }
        return this.weight;
    }

    public final boolean useFireworks() {
        return this.firework;
    }

    @NotNull
    public final Prize getAlternativePrize() {
        return this.alternativePrize;
    }

    public final boolean hasAlternativePrize() {
        return this.alternativePrize == null;
    }

    public final boolean hasPermission(@NotNull Player player) {
        if (player.isOp()) {
            return false;
        }
        for (String permission : this.permissions) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public void broadcast(@NotNull Player target, @NotNull Crate crate) {
        if (this.broadcastToggle) {
            this.send(target, crate);
        } else if (crate.isBroadcastToggled()) {
            this.send(target, crate);
        }
    }

    private void send(@NotNull Player target, @NotNull Crate crate) {
        Server server = this.plugin.getServer();
        List<String> messages = this.broadcastToggle ? this.broadcastMessages : crate.getBroadcastMessages();
        String permission = this.broadcastToggle ? this.broadcastPermission : crate.getBroadcastPermission();
        String current_pulls = String.valueOf(PrizeManager.getCurrentPulls(this, crate));
        String max_pulls = String.valueOf(this.getMaxPulls());
        String message = StringUtils.toString(messages);
        Map<String, String> placeholders = Map.of("%player%", target.getName(), "%crate%", crate.getCrateName(), "%reward%", this.getPrizeName().replaceAll("%maxpulls%", max_pulls).replaceAll("%pulls%", current_pulls), "%maxpulls%", max_pulls, "%pulls%", current_pulls, "%reward_stripped%", this.getStrippedName());
        Component component = AdvUtils.parse(MiscUtils.populatePlaceholders((CommandSender)target, message, placeholders));
        if (permission.isEmpty()) {
            server.broadcast(component);
            return;
        }
        server.broadcast(component, permission);
    }

    @NotNull
    private LegacyItemBuilder display() {
        LegacyItemBuilder builder = new LegacyItemBuilder(this.plugin);
        try {
            ConfigurationSection potions;
            EntityType type;
            if (this.section.contains("DisplayData")) {
                builder = builder.fromBase64(this.section.getString("DisplayData", ""));
            }
            if (this.section.contains("DisplayName")) {
                builder.setDisplayName(this.prizeName);
            }
            if (this.section.contains("DisplayItem")) {
                builder.withType(this.section.getString("DisplayItem", "red_terracotta").toLowerCase());
            }
            if (this.section.contains("DisplayAmount")) {
                builder.setAmount(this.section.getInt("DisplayAmount", 1));
            }
            if (this.section.contains("DisplayLore") && !this.section.contains("Lore")) {
                builder.setDisplayLore(this.section.getStringList("DisplayLore"));
            }
            if (this.section.contains("Lore")) {
                if (MiscUtils.isLogging()) {
                    List.of("Deprecated usage of Lore in your Prize " + this.sectionName + " in " + this.crateName + ".yml, please change Lore to DisplayLore", "Lore will be removed in the next major version of Minecraft in favor of DisplayLore", "You can turn my nagging off in config.yml, verbose_logging: true -> false").forEach(arg_0 -> ((ComponentLogger)this.logger).warn(arg_0));
                }
                builder.setDisplayLore(this.section.getStringList("Lore"));
            }
            if (this.section.contains("Glowing")) {
                builder.setGlowing(this.section.getBoolean("Glowing", false));
            }
            builder.setDamage(this.section.getInt("DisplayDamage", 0));
            if (this.section.contains("Patterns")) {
                if (MiscUtils.isLogging()) {
                    List.of("Deprecated usage of Patterns in your Prize " + this.sectionName + " in " + this.crateName + ".yml, please change Patterns to DisplayPatterns", "Patterns will be removed in the next major version of Minecraft in favor of DisplayPatterns", "You can turn my nagging off in config.yml, verbose_logging: true -> false").forEach(arg_0 -> ((ComponentLogger)this.logger).warn(arg_0));
                }
                for (String pattern : this.section.getStringList("Patterns")) {
                    builder.addPattern(pattern.toLowerCase());
                }
            }
            if (this.section.contains("DisplayPatterns")) {
                for (String pattern : this.section.getStringList("DisplayPatterns")) {
                    builder.addPattern(pattern.toLowerCase());
                }
            }
            builder.setHidingItemFlags(this.section.getBoolean("HideItemFlags", false) || !this.section.getStringList("Flags").isEmpty());
            builder.setUnbreakable(this.section.getBoolean("Unbreakable", false));
            builder.setCustomModelData(this.section.getString("Settings.Custom-Model-Data", ""));
            builder.setItemModel(this.section.getString("Settings.Model.Namespace", ""), this.section.getString("Settings.Model.Id", ""));
            if (this.section.contains("Settings.Mob-Type") && (type = ItemUtils.getEntity(this.section.getString("Settings.Mob-Type", "cow"))) != null) {
                builder.setEntityType(type);
            }
            if (this.section.contains("Settings.RGB")) {
                @Nullable Color color = ColorUtils.getRGB(this.section.getString("Settings.RGB", ""));
                if (color != null) {
                    builder.setColor(color);
                }
            } else if (this.section.contains("Settings.Color")) {
                builder.setColor(ColorUtils.getColor(this.section.getString("Settings.Color", "RED")));
            }
            if (this.section.contains("Skull")) {
                builder.setSkull(this.section.getString("Skull", ""));
            }
            if (this.section.contains("Player")) {
                builder.setPlayer(this.section.getString("Player", ""));
            }
            if (this.section.contains("DisplayTrim.Pattern") && builder.isArmor()) {
                builder.applyTrimPattern(this.section.getString("DisplayTrim.Pattern", "sentry"));
            }
            if (this.section.contains("DisplayTrim.Material") && builder.isArmor()) {
                builder.applyTrimMaterial(this.section.getString("DisplayTrim.Material", "quartz"));
            }
            if (this.section.contains("DisplayEnchantments")) {
                for (String ench : this.section.getStringList("DisplayEnchantments")) {
                    String[] value = ench.split(":");
                    builder.addEnchantment(value[0], Integer.parseInt(value[1]), true);
                }
            }
            if (this.section.contains("DisplayPotions") && (potions = this.section.getConfigurationSection("DisplayPotions")) != null) {
                for (String potion : potions.getKeys(false)) {
                    ConfigurationSection data;
                    PotionEffectType type2 = ItemUtils.getPotionEffect(potion);
                    if (type2 == null || (data = potions.getConfigurationSection(potion)) == null) continue;
                    int duration = data.getInt("duration", 10) * 20;
                    int level = data.getInt("level", 1);
                    builder.addPotionEffect(type2, duration, level);
                }
            }
            return builder;
        }
        catch (Exception exception) {
            return (LegacyItemBuilder)((LegacyItemBuilder)new LegacyItemBuilder(this.plugin, (ItemType)ItemType.RED_TERRACOTTA).setDisplayName("<red><bold>ERROR")).setDisplayLore(List.of("<red>There was an error with one of your prizes!", "<red>The reward in question is labeled: <yellow>" + this.section.getName() + " <red>in crate: <yellow>" + this.crateName, "<red>Name of the reward is " + this.section.getString("DisplayName"), "<red>If you are confused, Stop by our discord for support!"));
        }
    }

    public final List<ItemStack> getEditorItems() {
        return this.editorItems;
    }

    public final int getMaxPulls() {
        return this.maxPulls == -1 ? 0 : this.maxPulls;
    }
}

