/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator;

import ch.jalu.configme.SettingsManager;
import com.badbones69.crazycrates.core.config.ConfigManager;
import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import com.badbones69.crazycrates.paper.utils.ItemUtils;
import com.ryderbelserion.fusion.core.api.utils.StringUtils;
import com.ryderbelserion.fusion.paper.files.FileManager;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class ICrateMigrator {
    protected final CrazyCrates plugin = CrazyCrates.getPlugin();
    protected final ComponentLogger logger = this.plugin.getComponentLogger();
    protected final Path dataPath = this.plugin.getDataPath();
    protected final CrateManager crateManager = this.plugin.getCrateManager();
    protected final SettingsManager config = ConfigManager.getConfig();
    protected final SettingsManager messages = ConfigManager.getMessages();
    protected final FileManager fileManager = this.plugin.getFileManager();
    protected final CommandSender sender;
    protected final MigrationType type;
    protected final long startTime = System.nanoTime();
    protected String crateName;

    public ICrateMigrator(CommandSender sender, MigrationType type) {
        this.sender = sender;
        this.type = type;
    }

    public ICrateMigrator(CommandSender sender, MigrationType type, String crateName) {
        this(sender, type);
        this.crateName = crateName;
    }

    public abstract void run();

    public abstract <T> void set(ConfigurationSection var1, String var2, T var3);

    public File getCratesDirectory() {
        return null;
    }

    public void sendMessage(List<String> files, int success, int failed) {
        Messages.successfully_migrated.sendMessage(this.sender, Map.of("{files}", files.size() > 1 ? StringUtils.toString(files) : (files.isEmpty() ? "N/A" : files.getFirst()), "{succeeded_amount}", String.valueOf(success), "{failed_amount}", String.valueOf(failed), "{type}", this.type.getName(), "{time}", this.time()));
    }

    public void migrate(PaperCustomFile customFile, String crateName) {
        YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
        ConfigurationSection crate = configuration.getConfigurationSection("Crate");
        if (crate == null) {
            Messages.error_migrating.sendMessage(this.sender, Map.of("{file}", crateName.isEmpty() ? customFile.getPrettyName() : crateName, "{type}", this.type.getName(), "{reason}", "File could not be found in our data, likely invalid yml file that didn't load properly."));
            return;
        }
        this.set(crate, "Item", crate.getString("Item", "diamond").toLowerCase());
        this.set(crate, "Preview.Glass.Item", crate.getString("Preview.Glass.Item", "gray_stained_glass_pane").toLowerCase());
        this.set(crate, "PhysicalKey.Item", crate.getString("PhysicalKey.Item", "lime_dye").toLowerCase());
        ConfigurationSection prizes = crate.getConfigurationSection("Prizes");
        if (prizes != null) {
            for (String value : prizes.getKeys(false)) {
                ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                if (prizeSection == null) continue;
                if (prizeSection.contains("DisplayItem")) {
                    this.set(prizeSection, "DisplayItem", prizeSection.getString("DisplayItem", "red_terracotta").toLowerCase());
                }
                if (prizeSection.contains("DisplayTrim")) {
                    this.set(prizeSection, "DisplayTrim.Material", prizeSection.getString("DisplayTrim.Material", "quartz").toLowerCase());
                    this.set(prizeSection, "DisplayTrim.Pattern", prizeSection.getString("DisplayTrim.Pattern", "sentry").toLowerCase());
                }
                if (!prizeSection.contains("DisplayEnchantments")) continue;
                ArrayList enchants = new ArrayList();
                prizeSection.getStringList("DisplayEnchantments").forEach(enchant -> enchants.add(ItemUtils.getEnchant(enchant)));
                this.set(prizeSection, "DisplayEnchantments", enchants);
            }
        }
        customFile.save();
        customFile.load();
    }

    public final String time() {
        double time = (double)(System.nanoTime() - this.startTime) / 1.0E9;
        return String.format(Locale.ROOT, "%.3fs", time);
    }
}

