/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.types.deprecation;

import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.ICrateMigrator;
import com.badbones69.crazycrates.paper.commands.crates.types.admin.crates.migrator.enums.MigrationType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.core.api.enums.FileType;
import com.ryderbelserion.fusion.core.api.interfaces.files.ICustomFile;
import com.ryderbelserion.fusion.paper.files.types.PaperCustomFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class WeightMigrator
extends ICrateMigrator {
    public WeightMigrator(CommandSender sender) {
        super(sender, MigrationType.WEIGHT_MIGRATION);
    }

    @Override
    public void run() {
        Collection<ICustomFile<ICustomFile<?>>> customFiles = this.fileManager.getCustomFiles().values();
        ArrayList failed = new ArrayList();
        ArrayList success = new ArrayList();
        customFiles.forEach(key -> {
            try {
                ConfigurationSection prizes;
                ConfigurationSection tiers;
                if (key.isStatic() || !key.isLoaded() || key.getFileType() != FileType.PAPER) {
                    return;
                }
                PaperCustomFile customFile = (PaperCustomFile)key;
                YamlConfiguration configuration = (YamlConfiguration)customFile.getConfiguration();
                ConfigurationSection section = configuration.getConfigurationSection("Crate");
                if (section == null) {
                    return;
                }
                boolean isSave = false;
                if (section.contains("Tiers") && (tiers = section.getConfigurationSection("Tiers")) != null) {
                    tiers.getKeys(false).forEach(pair -> {
                        ConfigurationSection tier = tiers.getConfigurationSection(pair);
                        if (tier != null) {
                            int chance = tier.getInt("Chance");
                            int maxRange = tier.getInt("MaxRange");
                            if (maxRange > 100000) {
                                maxRange = 100000;
                            }
                            tier.set("Weight", (Object)MiscUtils.calculateWeight(chance, maxRange));
                        }
                    });
                    isSave = true;
                }
                if ((prizes = section.getConfigurationSection("Prizes")) != null) {
                    for (String value : prizes.getKeys(false)) {
                        ConfigurationSection prizeSection = prizes.getConfigurationSection(value);
                        if (prizeSection == null) continue;
                        int chance = 10;
                        int maxRange = 100;
                        if (prizeSection.contains("Chance")) {
                            chance = prizeSection.getInt("Chance", 10);
                            isSave = true;
                        }
                        if (prizeSection.contains("MaxRange")) {
                            maxRange = prizeSection.getInt("MaxRange", 100);
                            isSave = true;
                        }
                        if (maxRange > 100000) {
                            maxRange = 100000;
                        }
                        prizeSection.set("Weight", (Object)MiscUtils.calculateWeight(chance, maxRange));
                    }
                }
                if (isSave) {
                    customFile.save();
                }
                success.add("<green>\u2937 " + customFile.getFileName());
            }
            catch (Exception exception) {
                failed.add("<red>\u2937 " + key.getFileName());
            }
        });
        int convertedCrates = success.size();
        int failedCrates = failed.size();
        ArrayList<String> files = new ArrayList<String>(failedCrates + convertedCrates);
        files.addAll(failed);
        files.addAll(success);
        this.sendMessage(files, convertedCrates, failedCrates);
        this.fileManager.init((List)new ArrayList());
        this.crateManager.loadHolograms();
        this.crateManager.loadCrates();
    }

    @Override
    public <T> void set(ConfigurationSection section, String path, T value) {
        section.set(path, value);
    }

    @Override
    public final File getCratesDirectory() {
        return new File(this.plugin.getDataFolder(), "crates");
    }
}

