/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.commands.crates.types.player;

import com.badbones69.crazycrates.paper.CrazyCrates;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.Plugins;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.managers.BukkitUserManager;
import com.badbones69.crazycrates.paper.tasks.crates.CrateManager;
import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotations.ArgName;
import dev.triumphteam.cmd.core.annotations.Command;
import dev.triumphteam.cmd.core.annotations.Description;
import dev.triumphteam.cmd.core.annotations.Optional;
import dev.triumphteam.cmd.core.annotations.Suggestion;
import dev.triumphteam.cmd.core.annotations.Syntax;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

@Command(value="keys", alias={"key"})
@Description(value="Views the amount of keys you/others have.")
public class CommandKey {
    private final CrazyCrates plugin = CrazyCrates.getPlugin();
    private final BukkitUserManager userManager = this.plugin.getUserManager();
    private final CrateManager crateManager = this.plugin.getCrateManager();

    @Command
    @Permission(value={"crazycrates.keys"}, def=PermissionDefault.TRUE)
    @Syntax(value="/keys")
    public void personal(Player player) {
        this.getKeys(player, (CommandSender)player, Messages.virtual_keys_header.getMessage((CommandSender)player, "{crates_opened}", String.valueOf(this.userManager.getTotalCratesOpened(player.getUniqueId()))), Messages.no_virtual_key.getMessage((CommandSender)player));
    }

    @Command(value="view")
    @Permission(value={"crazycrates.keys-others"})
    @Syntax(value="/keys view [player_name]")
    public void view(CommandSender sender, @ArgName(value="player") @Optional @Suggestion(value="players") Player target) {
        if (target == null) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.personal(player);
                return;
            }
            return;
        }
        String targetName = target.getName();
        if (targetName.equalsIgnoreCase(sender.getName())) {
            this.personal(target);
            return;
        }
        this.getKeys(target, sender, Messages.other_player_no_keys_header.getMessage((CommandSender)target, Map.of("{crates_opened}", String.valueOf(this.userManager.getTotalCratesOpened(target.getUniqueId())), "{player}", targetName)), Messages.other_player_no_keys.getMessage((CommandSender)target, "{player}", targetName));
    }

    private void getKeys(@NotNull Player player, @NotNull CommandSender sender, @NotNull String header, @NotNull String content) {
        if (header.isEmpty() || content.isEmpty()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        ArrayList<String> message = new ArrayList<String>();
        message.add(header);
        HashMap keys = new HashMap();
        this.crateManager.getUsableCrates().forEach(crate -> keys.put(crate, this.userManager.getVirtualKeys(uuid, crate.getFileName())));
        boolean hasKeys = false;
        for (Crate crate2 : keys.keySet()) {
            int amount = (Integer)keys.get(crate2);
            if (amount <= 0) continue;
            hasKeys = true;
            message.add(Messages.per_crate.getMessage((CommandSender)player, Map.of("{crate_opened}", String.valueOf(this.userManager.getCrateOpened(uuid, crate2.getFileName())), "{keys}", String.valueOf(amount), "{crate}", crate2.getCrateName())));
        }
        if (Plugins.placeholder_api.isEnabled()) {
            if (sender instanceof Player) {
                Player person = (Player)sender;
                if (hasKeys) {
                    message.forEach(line -> person.sendRichMessage(PlaceholderAPI.setPlaceholders((Player)person, (String)line)));
                    return;
                }
                sender.sendRichMessage(PlaceholderAPI.setPlaceholders((Player)person, (String)content));
                return;
            }
            return;
        }
        if (hasKeys) {
            message.forEach(arg_0 -> ((CommandSender)sender).sendRichMessage(arg_0));
            return;
        }
        sender.sendRichMessage(content);
    }
}

