/*
 * Decompiled with CFR 0.152.
 */
package com.badbones69.crazycrates.paper.tasks.crates.types;

import com.badbones69.crazycrates.paper.api.ChestManager;
import com.badbones69.crazycrates.paper.api.PrizeManager;
import com.badbones69.crazycrates.paper.api.builders.CrateBuilder;
import com.badbones69.crazycrates.paper.api.builders.types.features.CrateSpinMenu;
import com.badbones69.crazycrates.paper.api.enums.Messages;
import com.badbones69.crazycrates.paper.api.enums.other.keys.FileKeys;
import com.badbones69.crazycrates.paper.api.objects.Crate;
import com.badbones69.crazycrates.paper.api.objects.Prize;
import com.badbones69.crazycrates.paper.api.objects.gui.GuiSettings;
import com.badbones69.crazycrates.paper.managers.events.enums.EventType;
import com.badbones69.crazycrates.paper.utils.MiscUtils;
import com.ryderbelserion.fusion.paper.api.scheduler.FoliaScheduler;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.crazycrew.crazycrates.api.enums.types.KeyType;

public class QuickCrate
extends CrateBuilder {
    private final Player player = this.getPlayer();
    private final Location location = this.getLocation();
    private final UUID uuid = this.player.getUniqueId();
    private final Crate crate = this.getCrate();

    public QuickCrate(@NotNull Crate crate, @NotNull Player player, @NotNull Location location) {
        super(crate, player, location);
    }

    @Override
    public void open(@NotNull KeyType type, boolean checkHand, boolean isSilent, @NotNull EventType eventType) {
        int keys;
        if (this.isCrateEventValid(type, checkHand, isSilent, eventType)) {
            return;
        }
        String fileName = this.crate.getFileName();
        switch (type) {
            case virtual_key: {
                int n = this.userManager.getVirtualKeys(this.uuid, fileName);
                break;
            }
            case physical_key: {
                int n = this.userManager.getPhysicalKeys(this.uuid, fileName);
                break;
            }
            default: {
                int n = keys = 1;
            }
        }
        if (this.crate.useRequiredKeys() && keys < this.crate.getRequiredKeys()) {
            Messages.not_enough_keys.sendMessage((CommandSender)this.player, Map.of("{required_amount}", String.valueOf(this.crate.getRequiredKeys()), "{key_amount}", String.valueOf(this.crate.getRequiredKeys()), "{amount}", String.valueOf(keys), "{crate}", this.crate.getCrateName(), "{key}", this.crate.getKeyName()));
            this.crateManager.removePlayerFromOpeningList(this.player);
            return;
        }
        this.crateManager.addCrateInUse(this.player, this.location);
        if (this.player.isSneaking() && keys > 1) {
            int used;
            for (used = 0; keys > 0 && !MiscUtils.isInventoryFull(this.player) && used < this.crate.getMaxMassOpen(); ++used, --keys) {
                Prize prize = this.crate.pickPrize(this.player);
                PrizeManager.givePrize(this.player, this.location.clone().add(0.5, 1.0, 0.5), this.crate, prize);
            }
            boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, used, false);
            if (!keyCheck) {
                MiscUtils.failedToTakeKey((CommandSender)this.player, fileName);
                this.crateManager.removePlayerFromOpeningList(this.player);
                this.crateManager.removeCrateInUse(this.player);
                return;
            }
            this.crateManager.endQuickCrate(this.player, this.location, this.crate, true);
            return;
        }
        boolean keyCheck = this.userManager.takeKeys(this.uuid, fileName, type, this.crate.useRequiredKeys() ? this.crate.getRequiredKeys() : 1, true);
        if (!keyCheck) {
            MiscUtils.failedToTakeKey((CommandSender)this.player, fileName);
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            return;
        }
        Prize prize = this.crate.pickPrize(this.player);
        if (this.crate.isCyclePrize() && !PrizeManager.isCapped(this.crate, this.player)) {
            new CrateSpinMenu(this.player, new GuiSettings(this.crate, prize, FileKeys.respin_gui.getConfiguration())).open();
            this.crateManager.removePlayerFromOpeningList(this.player);
            this.crateManager.removeCrateInUse(this.player);
            return;
        }
        this.userManager.removeRespinPrize(this.uuid, fileName);
        if (!this.crate.isCyclePersistRestart()) {
            this.userManager.removeRespinCrate(this.uuid, fileName, this.userManager.getCrateRespin(this.uuid, fileName));
        }
        this.displayItem(prize);
        ChestManager.openChest(this.location.getBlock(), true);
        PrizeManager.givePrize(this.player, this.location.clone().add(0.5, 1.0, 0.5), this.crate, prize);
        this.addCrateTask(new FoliaScheduler(this.plugin, null, (Entity)this.player){

            @Override
            public void run() {
                QuickCrate.this.crateManager.endQuickCrate(QuickCrate.this.player, QuickCrate.this.location, QuickCrate.this.crate, false);
            }
        }.runDelayed(40L));
    }
}

