/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.command;

import dev.triumphteam.cmd.core.command.InternalParentCommand;
import dev.triumphteam.cmd.core.exceptions.CommandExecutionException;
import dev.triumphteam.cmd.core.extension.meta.MetaKey;
import dev.triumphteam.cmd.core.processor.RootCommandProcessor;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InternalRootCommand<D, S, ST>
extends InternalParentCommand<D, S, ST> {
    private final String name;
    private final List<String> aliases;
    private final String description;
    private final String syntax;

    public InternalRootCommand(@NotNull RootCommandProcessor<D, S, ST> processor) {
        super(processor);
        this.name = processor.getName();
        this.description = this.getMeta().getOrDefault(MetaKey.DESCRIPTION, "");
        this.aliases = processor.getAliases();
        this.syntax = "/" + this.name;
    }

    public void execute(@NotNull S sender, @NotNull Deque<String> arguments) {
        if (!this.getSettings().testRequirements(this.getMessageRegistry(), sender, this.getMeta(), this.getSenderExtension())) {
            return;
        }
        try {
            this.findAndExecute(sender, null, arguments);
        }
        catch (Throwable exception) {
            throw new CommandExecutionException("An error occurred while executing the command").initCause(exception instanceof InvocationTargetException ? exception.getCause() : exception);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    @NotNull
    public String getSyntax() {
        return this.syntax;
    }

    @Override
    public boolean hasArguments() {
        return false;
    }
}

