/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes;

import com.mojang.logging.LogUtils;
import de.sarocesch.sarosslopes.ModConfigHolder;
import de.sarocesch.sarosslopes.client.render.SlopeBERenderer;
import de.sarocesch.sarosslopes.registry.ModBlockEntities;
import de.sarocesch.sarosslopes.registry.ModBlocks;
import de.sarocesch.sarosslopes.registry.ModItems;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="sarosslopes")
public class SarosSlopes {
    public static final String MODID = "sarosslopes";
    private static final Logger LOGGER = LogUtils.getLogger();

    public SarosSlopes(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigHolder.SPEC);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.SLOPES_TOOL);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SarosSlopes: common setup");
    }

    @Mod.EventBusSubscriber(modid="sarosslopes", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SLOPE_BE.get(), SlopeBERenderer::new);
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("SarosSlopes: client setup");
        }
    }
}

