/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes.block;

import de.sarocesch.sarosslopes.block.SlopeBlockEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class SlopeBlock
extends BaseEntityBlock {
    public static final IntegerProperty STEPS = IntegerProperty.m_61631_((String)"steps", (int)0, (int)15);

    public SlopeBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STEPS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STEPS});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int steps = (Integer)state.m_61143_((Property)STEPS);
        double height = (double)(16 - steps) / 16.0;
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)Math.max(0.0625, height), (double)1.0);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SlopeBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack tool) {
        SlopeBlockEntity sbe;
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            sbe.getOriginalState().m_60734_().m_6240_(level, player, pos, sbe.getOriginalState(), null, tool);
        } else {
            super.m_6240_(level, player, pos, state, be, tool);
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        SlopeBlockEntity sbe;
        BlockEntity be;
        if (level instanceof Level) {
            Level lvl = (Level)level;
            v0 = lvl.m_7702_(pos);
        } else {
            v0 = be = null;
        }
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            return sbe.getOriginalState().getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        SlopeBlockEntity sbe;
        BlockEntity be = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            return sbe.getOriginalState().m_287290_(builder.m_287286_(LootContextParams.f_81461_, (Object)sbe.getOriginalState()));
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        SlopeBlockEntity sbe;
        BlockEntity be2 = level.m_7702_(pos);
        if (be2 instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be2).getOriginalState() != null) {
            return sbe.getOriginalState().m_60734_().m_7397_(level, pos, sbe.getOriginalState());
        }
        return super.m_7397_(level, pos, state);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        SlopeBlockEntity sbe;
        BlockEntity be3 = level.m_7702_(pos);
        if (be3 instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be3).getOriginalState() != null) {
            sbe.getOriginalState().m_60734_().m_214162_(sbe.getOriginalState(), level, pos, random);
        }
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                SlopeBlockEntity sbe;
                BlockEntity be = level.m_7702_(pos);
                if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockState original = sbe.getOriginalState();
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel model = dispatcher.m_110910_(original);
                    for (Direction direction : Direction.values()) {
                        for (int i = 0; i < 4; ++i) {
                            double x = (double)pos.m_123341_() + level.f_46441_.m_188500_();
                            double y = (double)pos.m_123342_() + level.f_46441_.m_188500_();
                            double z = (double)pos.m_123343_() + level.f_46441_.m_188500_();
                            manager.m_107344_(new TerrainParticle((ClientLevel)level, x, y, z, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1, original, pos).updateSprite(original, pos));
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                SlopeBlockEntity sbe;
                BlockHitResult blockHit;
                BlockPos pos;
                BlockEntity be;
                if (target instanceof BlockHitResult && (be = level.m_7702_(pos = (blockHit = (BlockHitResult)target).m_82425_())) instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockState original = sbe.getOriginalState();
                    Direction side = blockHit.m_82434_();
                    int x = pos.m_123341_();
                    int y = pos.m_123342_();
                    int z = pos.m_123343_();
                    for (int i = 0; i < 4; ++i) {
                        double px = (double)x + level.f_46441_.m_188500_();
                        double py = (double)y + level.f_46441_.m_188500_();
                        double pz = (double)z + level.f_46441_.m_188500_();
                        switch (side) {
                            case DOWN: {
                                py = y;
                                break;
                            }
                            case UP: {
                                py = y + 1;
                                break;
                            }
                            case NORTH: {
                                pz = z;
                                break;
                            }
                            case SOUTH: {
                                pz = z + 1;
                                break;
                            }
                            case WEST: {
                                px = x;
                                break;
                            }
                            case EAST: {
                                px = x + 1;
                            }
                        }
                        manager.m_107344_(new TerrainParticle((ClientLevel)level, px, py, pz, 0.0, 0.0, 0.0, original, pos).updateSprite(original, pos));
                    }
                    return true;
                }
                return false;
            }

            public TextureAtlasSprite getParticleIcon(BlockState state, BlockAndTintGetter level, BlockPos pos) {
                SlopeBlockEntity sbe;
                BlockEntity be;
                if (level != null && (be = level.m_7702_(pos)) instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel model = dispatcher.m_110910_(sbe.getOriginalState());
                    return model.m_6160_();
                }
                BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                BakedModel model = dispatcher.m_110910_(state);
                return model.m_6160_();
            }
        });
    }
}

