/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes;

import de.sarocesch.sarosslopes.block.SlopeBlock;
import de.sarocesch.sarosslopes.block.SlopeBlockEntity;
import de.sarocesch.sarosslopes.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SlopesToolItem
extends Item {
    public SlopesToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState target = level.getBlockState(pos);
        if (target.getBlock() != ModBlocks.SLOPE_BLOCK.get()) {
            BlockEntity be;
            if (!target.isCollisionShapeFullBlock((BlockGetter)level, pos)) {
                return InteractionResult.PASS;
            }
            BlockState newState = (BlockState)((Block)ModBlocks.SLOPE_BLOCK.get()).defaultBlockState().setValue((Property)SlopeBlock.STEPS, (Comparable)Integer.valueOf(1));
            if (level.setBlock(pos, newState, 3) && (be = level.getBlockEntity(pos)) instanceof SlopeBlockEntity) {
                SlopeBlockEntity slopeBE = (SlopeBlockEntity)be;
                slopeBE.setOriginalState(target);
            }
            return InteractionResult.CONSUME;
        }
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)SlopeBlock.STEPS)) {
            int val = (Integer)state.getValue((Property)SlopeBlock.STEPS);
            if (val < 15) {
                level.setBlock(pos, (BlockState)state.setValue((Property)SlopeBlock.STEPS, (Comparable)Integer.valueOf(val + 1)), 3);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

