/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes.block;

import com.mojang.serialization.MapCodec;
import de.sarocesch.sarosslopes.block.SlopeBlockEntity;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class SlopeBlock
extends BaseEntityBlock {
    public static final IntegerProperty STEPS = IntegerProperty.create((String)"steps", (int)0, (int)15);
    public static final MapCodec<SlopeBlock> CODEC = SlopeBlock.simpleCodec(SlopeBlock::new);

    public SlopeBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STEPS, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STEPS});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int steps = (Integer)state.getValue((Property)STEPS);
        double height = (double)(16 - steps) / 16.0;
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)Math.max(0.0625, height), (double)1.0);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SlopeBlockEntity(pos, state);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack tool) {
        SlopeBlockEntity sbe;
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            sbe.getOriginalState().getBlock().playerDestroy(level, player, pos, sbe.getOriginalState(), null, tool);
        } else {
            super.playerDestroy(level, player, pos, state, be, tool);
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        SlopeBlockEntity sbe;
        BlockEntity be;
        if (level instanceof Level) {
            Level lvl = (Level)level;
            v0 = lvl.getBlockEntity(pos);
        } else {
            v0 = be = null;
        }
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            return sbe.getOriginalState().getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        SlopeBlockEntity sbe;
        BlockEntity be = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
            return sbe.getOriginalState().getDrops(builder.withParameter(LootContextParams.BLOCK_STATE, (Object)sbe.getOriginalState()));
        }
        return super.getDrops(state, builder);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        SlopeBlockEntity sbe;
        Level lvl;
        BlockEntity be2;
        if (level instanceof Level && (be2 = (lvl = (Level)level).getBlockEntity(pos)) instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be2).getOriginalState() != null) {
            return sbe.getOriginalState().getBlock().getCloneItemStack(level, pos, sbe.getOriginalState());
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        SlopeBlockEntity sbe;
        BlockEntity be3 = level.getBlockEntity(pos);
        if (be3 instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be3).getOriginalState() != null) {
            sbe.getOriginalState().getBlock().animateTick(sbe.getOriginalState(), level, pos, random);
        }
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(this){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                SlopeBlockEntity sbe;
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockState original = sbe.getOriginalState();
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel model = dispatcher.getBlockModel(original);
                    for (Direction direction : Direction.values()) {
                        for (int i = 0; i < 4; ++i) {
                            double x = (double)pos.getX() + level.random.nextDouble();
                            double y = (double)pos.getY() + level.random.nextDouble();
                            double z = (double)pos.getZ() + level.random.nextDouble();
                            manager.add(new TerrainParticle((ClientLevel)level, x, y, z, (level.random.nextDouble() - 0.5) * 0.1, (level.random.nextDouble() - 0.5) * 0.1, (level.random.nextDouble() - 0.5) * 0.1, original, pos).updateSprite(original, pos));
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
                SlopeBlockEntity sbe;
                BlockHitResult blockHit;
                BlockPos pos;
                BlockEntity be;
                if (target instanceof BlockHitResult && (be = level.getBlockEntity(pos = (blockHit = (BlockHitResult)target).getBlockPos())) instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockState original = sbe.getOriginalState();
                    Direction side = blockHit.getDirection();
                    int x = pos.getX();
                    int y = pos.getY();
                    int z = pos.getZ();
                    for (int i = 0; i < 4; ++i) {
                        double px = (double)x + level.random.nextDouble();
                        double py = (double)y + level.random.nextDouble();
                        double pz = (double)z + level.random.nextDouble();
                        switch (side) {
                            case DOWN: {
                                py = y;
                                break;
                            }
                            case UP: {
                                py = y + 1;
                                break;
                            }
                            case NORTH: {
                                pz = z;
                                break;
                            }
                            case SOUTH: {
                                pz = z + 1;
                                break;
                            }
                            case WEST: {
                                px = x;
                                break;
                            }
                            case EAST: {
                                px = x + 1;
                            }
                        }
                        manager.add(new TerrainParticle((ClientLevel)level, px, py, pz, 0.0, 0.0, 0.0, original, pos).updateSprite(original, pos));
                    }
                    return true;
                }
                return false;
            }

            public TextureAtlasSprite getParticleIcon(BlockState state, BlockAndTintGetter level, BlockPos pos) {
                SlopeBlockEntity sbe;
                BlockEntity be;
                if (level != null && (be = level.getBlockEntity(pos)) instanceof SlopeBlockEntity && (sbe = (SlopeBlockEntity)be).getOriginalState() != null) {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel model = dispatcher.getBlockModel(sbe.getOriginalState());
                    return model.getParticleIcon();
                }
                BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                BakedModel model = dispatcher.getBlockModel(state);
                return model.getParticleIcon();
            }
        });
    }
}

