/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes.block;

import de.sarocesch.sarosslopes.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SlopeBlockEntity
extends BlockEntity {
    private BlockState originalState;
    private CompoundTag pendingOriginalTag;

    public SlopeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SLOPE_BE.get(), pos, state);
    }

    public void setOriginalState(BlockState state) {
        this.originalState = state;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public BlockState getOriginalState() {
        return this.originalState;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.originalState != null) {
            tag.put("orig", (Tag)NbtUtils.writeBlockState((BlockState)this.originalState));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("orig")) {
            this.pendingOriginalTag = tag.getCompound("orig").copy();
            if (this.level != null) {
                HolderLookup.RegistryLookup lookup = this.level.registryAccess().lookupOrThrow(Registries.BLOCK);
                this.originalState = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)this.pendingOriginalTag);
            } else {
                this.originalState = null;
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.originalState != null) {
            tag.put("orig", (Tag)NbtUtils.writeBlockState((BlockState)this.originalState));
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        if (tag.contains("orig")) {
            this.pendingOriginalTag = tag.getCompound("orig").copy();
            if (this.level != null) {
                HolderLookup.RegistryLookup lookup = this.level.registryAccess().lookupOrThrow(Registries.BLOCK);
                this.originalState = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)this.pendingOriginalTag);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.originalState == null && this.pendingOriginalTag != null && this.level != null) {
            HolderLookup.RegistryLookup lookup = this.level.registryAccess().lookupOrThrow(Registries.BLOCK);
            this.originalState = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)this.pendingOriginalTag);
            this.pendingOriginalTag = null;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.handleUpdateTag(tag, registries);
        }
    }
}

