/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosslopes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.sarocesch.sarosslopes.block.SlopeBlock;
import de.sarocesch.sarosslopes.block.SlopeBlockEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class SlopeBERenderer
implements BlockEntityRenderer<SlopeBlockEntity> {
    private final BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();

    public SlopeBERenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(SlopeBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int overlay) {
        BlockState state = be.getBlockState();
        if (!(state.getBlock() instanceof SlopeBlock)) {
            return;
        }
        int steps = (Integer)state.getValue((Property)SlopeBlock.STEPS);
        float height = Math.max(0.0625f, (float)(16 - steps) / 16.0f);
        BlockState original = be.getOriginalState();
        if (original == null) {
            return;
        }
        BakedModel model = this.dispatcher.getBlockModel(original);
        TextureAtlasSprite spriteUp = this.getSprite(model, original, Direction.UP);
        TextureAtlasSprite spriteDown = this.getSprite(model, original, Direction.DOWN);
        TextureAtlasSprite spriteNorth = this.getSprite(model, original, Direction.NORTH);
        TextureAtlasSprite spriteSouth = this.getSprite(model, original, Direction.SOUTH);
        TextureAtlasSprite spriteWest = this.getSprite(model, original, Direction.WEST);
        TextureAtlasSprite spriteEast = this.getSprite(model, original, Direction.EAST);
        int tintIndexUp = this.getTintIndex(model, original, Direction.UP);
        int tintIndexDown = this.getTintIndex(model, original, Direction.DOWN);
        int tintIndexNorth = this.getTintIndex(model, original, Direction.NORTH);
        int tintIndexSouth = this.getTintIndex(model, original, Direction.SOUTH);
        int tintIndexWest = this.getTintIndex(model, original, Direction.WEST);
        int tintIndexEast = this.getTintIndex(model, original, Direction.EAST);
        Level level = be.getLevel();
        BlockPos pos = be.getBlockPos();
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        int tintUp = this.getTintColor(blockColors, original, level, pos, tintIndexUp);
        int tintDown = this.getTintColor(blockColors, original, level, pos, tintIndexDown);
        int tintNorth = this.getTintColor(blockColors, original, level, pos, tintIndexNorth);
        int tintSouth = this.getTintColor(blockColors, original, level, pos, tintIndexSouth);
        int tintWest = this.getTintColor(blockColors, original, level, pos, tintIndexWest);
        int tintEast = this.getTintColor(blockColors, original, level, pos, tintIndexEast);
        int lightUp = packedLight;
        int lightDown = packedLight;
        int lightNorth = packedLight;
        int lightSouth = packedLight;
        int lightWest = packedLight;
        int lightEast = packedLight;
        if (level != null) {
            lightUp = this.getLightLevel(level, pos, Direction.UP);
            lightDown = this.getLightLevel(level, pos, Direction.DOWN);
            lightNorth = this.getLightLevel(level, pos, Direction.NORTH);
            lightSouth = this.getLightLevel(level, pos, Direction.SOUTH);
            lightWest = this.getLightLevel(level, pos, Direction.WEST);
            lightEast = this.getLightLevel(level, pos, Direction.EAST);
        }
        VertexConsumer vc = buffer.getBuffer(RenderType.cutoutMipped());
        pose.pushPose();
        this.renderCroppedCube(pose, vc, spriteUp, spriteDown, spriteNorth, spriteSouth, spriteWest, spriteEast, height, lightUp, lightDown, lightNorth, lightSouth, lightWest, lightEast, overlay, tintUp, tintDown, tintNorth, tintSouth, tintWest, tintEast);
        pose.popPose();
    }

    private int getTintColor(BlockColors blockColors, BlockState state, Level level, BlockPos pos, int tintIndex) {
        if (level == null || tintIndex == -1) {
            return 0xFFFFFF;
        }
        return blockColors.getColor(state, (BlockAndTintGetter)level, pos, tintIndex);
    }

    private int getLightLevel(Level level, BlockPos pos, Direction direction) {
        return LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)pos);
    }

    private TextureAtlasSprite getSprite(BakedModel model, BlockState state, Direction face) {
        long rand = state.getSeed(BlockPos.ZERO);
        List quads = model.getQuads(state, face, RandomSource.create((long)rand));
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).getSprite();
        }
        return model.getParticleIcon();
    }

    private int getTintIndex(BakedModel model, BlockState state, Direction face) {
        long rand = state.getSeed(BlockPos.ZERO);
        List quads = model.getQuads(state, face, RandomSource.create((long)rand));
        if (!quads.isEmpty()) {
            return ((BakedQuad)quads.get(0)).getTintIndex();
        }
        return -1;
    }

    private void renderCroppedCube(PoseStack pose, VertexConsumer vc, TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east, float height, int lightUp, int lightDown, int lightNorth, int lightSouth, int lightWest, int lightEast, int overlay, int tintUp, int tintDown, int tintNorth, int tintSouth, int tintWest, int tintEast) {
        this.top(vc, pose, up, height, lightUp, overlay, tintUp);
        this.north(vc, pose, north, height, lightNorth, overlay, tintNorth);
        this.south(vc, pose, south, height, lightSouth, overlay, tintSouth);
        this.west(vc, pose, west, height, lightWest, overlay, tintWest);
        this.east(vc, pose, east, height, lightEast, overlay, tintEast);
        this.bottom(vc, pose, down, 0.0f, lightDown, overlay, tintDown);
    }

    private void top(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float y, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 1.0f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 1.0f;
        float b = (float)(tint & 0xFF) / 255.0f * 1.0f;
        vc.addVertex(m, 0.0f, y, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 1.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v0).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 0.0f, y, 0.0f).setColor(r, g, b, 1.0f).setUv(u0, v0).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
    }

    private void bottom(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float y, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * 0.5f;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * 0.5f;
        float b = (float)(tint & 0xFF) / 255.0f * 0.5f;
        vc.addVertex(m, 0.0f, y, 0.0f).setColor(r, g, b, 1.0f).setUv(u0, v0).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v0).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 1.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
        vc.addVertex(m, 0.0f, y, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, -1.0f, 0.0f);
    }

    private void north(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float vCrop = v0 + (v1 - v0) * (1.0f - h);
        boolean isTinted = tint != 0xFFFFFF;
        float multiplier = isTinted ? 0.55f : 0.8f;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * multiplier;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * multiplier;
        float b = (float)(tint & 0xFF) / 255.0f * multiplier;
        vc.addVertex(m, 0.0f, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 0.0f, h, 0.0f).setColor(r, g, b, 1.0f).setUv(u0, vCrop).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, h, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, vCrop).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void south(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float vCrop = v0 + (v1 - v0) * (1.0f - h);
        boolean isTinted = tint != 0xFFFFFF;
        float multiplier = isTinted ? 0.55f : 0.8f;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * multiplier;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * multiplier;
        float b = (float)(tint & 0xFF) / 255.0f * multiplier;
        vc.addVertex(m, 1.0f, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 1.0f, h, 1.0f).setColor(r, g, b, 1.0f).setUv(u1, vCrop).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, h, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, vCrop).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
    }

    private void west(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float vCrop = v0 + (v1 - v0) * (1.0f - h);
        boolean isTinted = tint != 0xFFFFFF;
        float multiplier = isTinted ? 0.45f : 0.6f;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * multiplier;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * multiplier;
        float b = (float)(tint & 0xFF) / 255.0f * multiplier;
        vc.addVertex(m, 0.0f, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 0.0f, h, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, vCrop).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 0.0f, h, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, vCrop).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 0.0f, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
    }

    private void east(VertexConsumer vc, PoseStack pose, TextureAtlasSprite sprite, float h, int light, int overlay, int tint) {
        Matrix4f m = pose.last().pose();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        float vCrop = v0 + (v1 - v0) * (1.0f - h);
        boolean isTinted = tint != 0xFFFFFF;
        float multiplier = isTinted ? 0.45f : 0.6f;
        float r = (float)(tint >> 16 & 0xFF) / 255.0f * multiplier;
        float g = (float)(tint >> 8 & 0xFF) / 255.0f * multiplier;
        float b = (float)(tint & 0xFF) / 255.0f * multiplier;
        vc.addVertex(m, 1.0f, 0.0f, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, v1).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 1.0f, h, 0.0f).setColor(r, g, b, 1.0f).setUv(u1, vCrop).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 1.0f, h, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, vCrop).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, 1.0f, 0.0f, 1.0f).setColor(r, g, b, 1.0f).setUv(u0, v1).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
    }

    public boolean shouldRenderOffScreen(SlopeBlockEntity blockEntity) {
        return true;
    }
}

