/*
 * Decompiled with CFR 0.152.
 */
package be.elmital.fixmcstats;

import be.elmital.fixmcstats.Config;
import be.elmital.fixmcstats.StatisticUtils;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixMCStats
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fix-mc-stats");

    public void onInitialize() {
        LOGGER.info("Initializing mod");
        try {
            LOGGER.info("Checking mod config...");
            Config.initConfig(LOGGER);
            LOGGER.info("Mod configured!");
            LOGGER.info("Checking for custom statistics");
            StatisticUtils.registerAllCustomStats(Config.instance(), LOGGER);
        }
        catch (SecurityException e) {
            LOGGER.trace("Can't load or generate config file! There is a read/write permission issue.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.trace("Can't load or generate config! If the file exists already delete it and it will be re-created on the next launch with the default values.", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOGGER.info("Mod initialized!");
    }
}

