/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xday.api;

import java.util.Objects;
import jn.willfrydev.xday.xDay;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;

public final class xDayAPI {
    private final xDay plugin;

    public xDayAPI(xDay plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin instance cannot be null");
    }

    public WeatherType getLockedWeather(World world) {
        Objects.requireNonNull(world, "World cannot be null");
        String setting = this.getLockedSetting(world.getName(), "lock-weather");
        return WeatherType.fromString(setting);
    }

    public TimeType getLockedTime(World world) {
        Objects.requireNonNull(world, "World cannot be null");
        String setting = this.getLockedSetting(world.getName(), "set-time");
        return TimeType.fromString(setting);
    }

    public void forceUpdate(World world) {
        Objects.requireNonNull(world, "World cannot be null");
        this.plugin.applySettings(world);
    }

    public void forceUpdateAllWorlds() {
        for (World world : Bukkit.getServer().getWorlds()) {
            this.forceUpdate(world);
        }
    }

    private String getLockedSetting(String worldName, String key) {
        FileConfiguration config = this.plugin.getConfig();
        String worldPath = "worlds." + worldName + "." + key;
        String defaultPath = "default-settings." + key;
        return config.getString(worldPath, config.getString(defaultPath, "disabled"));
    }

    public static enum WeatherType {
        CLEAR,
        RAIN,
        THUNDER,
        DISABLED;


        public static WeatherType fromString(String value) {
            if (value == null) {
                return DISABLED;
            }
            try {
                return WeatherType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DISABLED;
            }
        }
    }

    public static enum TimeType {
        DAY,
        NIGHT,
        NOON,
        MIDNIGHT,
        DISABLED;


        public static TimeType fromString(String value) {
            if (value == null) {
                return DISABLED;
            }
            try {
                return TimeType.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return DISABLED;
            }
        }
    }
}

