/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xday.util;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import jn.willfrydev.xday.lib.gson.JsonArray;
import jn.willfrydev.xday.lib.gson.JsonObject;
import jn.willfrydev.xday.lib.gson.JsonParser;
import jn.willfrydev.xday.xDay;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String PROJECT_ID = "r6WAKpDi";
    private final xDay plugin;
    private final String currentVersion;
    private String latestVersion;
    private String downloadLink;
    private boolean updateAvailable = false;

    public UpdateChecker(xDay plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void check() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/r6WAKpDi/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "xPlugins/xDay Update Checker");
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonArray versions = JsonParser.parseReader(reader).getAsJsonArray();
                    reader.close();
                    if (!versions.isEmpty()) {
                        JsonObject latest = versions.get(0).getAsJsonObject();
                        this.latestVersion = latest.get("version_number").getAsString();
                        if (!this.currentVersion.replace("v", "").equalsIgnoreCase(this.latestVersion.replace("v", ""))) {
                            this.updateAvailable = true;
                            this.downloadLink = "https://modrinth.com/plugin/r6WAKpDi/version/" + this.latestVersion;
                            this.notifyConsole();
                        }
                    }
                } else {
                    this.plugin.getLogger().warning("No se pudo verificar si hay actualizaciones (Modrinth API). C\u00f3digo de respuesta: " + connection.getResponseCode());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Ocurri\u00f3 un error al buscar actualizaciones: " + e.getMessage());
            }
        });
    }

    private void notifyConsole() {
        if (!this.updateAvailable) {
            return;
        }
        List messages = this.plugin.getConfig().getStringList("update-checker.notify-message");
        for (String line : messages) {
            this.plugin.getLogger().info(ChatColor.stripColor((String)this.formatMessage(line)));
        }
    }

    public void notifyPlayerOnJoin(Player player) {
        if (!this.updateAvailable) {
            return;
        }
        if (player.hasPermission("xday.update")) {
            List messages = this.plugin.getConfig().getStringList("update-checker.notify-message");
            for (String line : messages) {
                player.sendMessage(this.formatMessage(line));
            }
        }
    }

    private String formatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("%current_version%", this.currentVersion).replace("%new_version%", this.latestVersion).replace("%download_link%", this.downloadLink));
    }
}

