/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xday;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xday.api.xDayAPI;
import jn.willfrydev.xday.completers.UpdateListener;
import jn.willfrydev.xday.completers.xDayTabCompleter;
import jn.willfrydev.xday.metrics.Metrics;
import jn.willfrydev.xday.util.UpdateChecker;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class xDay
extends JavaPlugin
implements CommandExecutor {
    private static final int BSTATS_PLUGIN_ID = 27337;
    private static final String MESSAGES_FILE_NAME = "messages.yml";
    private static final Pattern HEX_PATTERN = Pattern.compile("<#[a-fA-F0-9]{6}>");
    private static final String[] ASCII_LOGO = new String[]{" _  _  ____   __   _  _ ", "( \\/ )(   \\ / _\\ ( \\/ )", " )  (  ) D (/   \\ )  / ", "(_/\\_)(____/\\_/\\_/(__/  "};
    private FileConfiguration messagesConfig = null;
    private File messagesFile = null;
    private BukkitTask weatherAndTimeTask;
    private static xDay instance;
    private static xDayAPI api;

    public void onEnable() {
        instance = this;
        api = new xDayAPI(this);
        this.saveDefaultConfig();
        this.saveDefaultMessages();
        this.getCommand("xday").setExecutor((CommandExecutor)this);
        this.getCommand("xday").setTabCompleter((TabCompleter)new xDayTabCompleter());
        this.startWeatherAndTimeTask();
        this.setupMetrics();
        this.setupUpdateChecker();
        this.sendStartupMessages();
    }

    public void onDisable() {
        if (this.weatherAndTimeTask != null && !this.weatherAndTimeTask.isCancelled()) {
            this.weatherAndTimeTask.cancel();
        }
        Bukkit.getConsoleSender().sendMessage("");
        for (String line : ASCII_LOGO) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + line);
        }
        Bukkit.getConsoleSender().sendMessage("");
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + " -> " + ChatColor.WHITE + "Estado: " + ChatColor.RED + "Desactivado.");
        Bukkit.getConsoleSender().sendMessage("");
    }

    private void startWeatherAndTimeTask() {
        if (this.weatherAndTimeTask != null) {
            this.weatherAndTimeTask.cancel();
        }
        this.weatherAndTimeTask = new BukkitRunnable(){

            public void run() {
                for (World world : Bukkit.getServer().getWorlds()) {
                    xDay.this.applySettings(world);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 100L);
    }

    public void applySettings(World world) {
        xDayAPI.WeatherType weatherType = api.getLockedWeather(world);
        xDayAPI.TimeType timeType = api.getLockedTime(world);
        switch (weatherType) {
            case CLEAR: {
                world.setStorm(false);
                world.setThundering(false);
                break;
            }
            case RAIN: {
                world.setStorm(true);
                world.setThundering(false);
                break;
            }
            case THUNDER: {
                world.setStorm(true);
                world.setThundering(true);
                break;
            }
        }
        switch (timeType) {
            case DAY: {
                world.setTime(1000L);
                break;
            }
            case NOON: {
                world.setTime(6000L);
                break;
            }
            case NIGHT: {
                world.setTime(13000L);
                break;
            }
            case MIDNIGHT: {
                world.setTime(18000L);
                break;
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendHelpMessage(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("xday.reload")) {
                sender.sendMessage(this.getMessage("no-permission"));
                return true;
            }
            this.reloadConfig();
            this.reloadMessages();
            this.startWeatherAndTimeTask();
            sender.sendMessage(this.getMessage("reload"));
            return true;
        }
        this.sendHelpMessage(sender);
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        List helpLines = this.getMessagesConfig().getStringList("help-message");
        for (String line : helpLines) {
            sender.sendMessage(this.formatColors(line));
        }
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 27337);
        metrics.addCustomChart(new Metrics.SingleLineChart("managed_worlds", () -> {
            FileConfiguration config = this.getConfig();
            if (config.isConfigurationSection("worlds")) {
                return config.getConfigurationSection("worlds").getKeys(false).size();
            }
            return 0;
        }));
    }

    private void setupUpdateChecker() {
        if (this.getConfig().getBoolean("update-checker.enabled", true)) {
            UpdateChecker updateChecker = new UpdateChecker(this);
            updateChecker.check();
            this.getServer().getPluginManager().registerEvents((Listener)new UpdateListener(updateChecker, this), (Plugin)this);
        }
    }

    private void sendStartupMessages() {
        Bukkit.getConsoleSender().sendMessage("");
        for (String line : ASCII_LOGO) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + line);
        }
        Bukkit.getConsoleSender().sendMessage("");
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + " -> " + ChatColor.WHITE + "Versi\u00f3n: " + ChatColor.YELLOW + this.getDescription().getVersion());
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + " -> " + ChatColor.WHITE + "Autor: " + ChatColor.YELLOW + (String)this.getDescription().getAuthors().get(0));
        Bukkit.getConsoleSender().sendMessage(ChatColor.GRAY + " -> " + ChatColor.WHITE + "Estado: " + ChatColor.GREEN + "Activado correctamente.");
        Bukkit.getConsoleSender().sendMessage("");
    }

    public String getMessage(String path) {
        String message = this.getMessagesConfig().getString(path, "&cMensaje no encontrado: " + path);
        String prefix = this.getMessagesConfig().getString("prefix", "");
        return this.formatColors(prefix + message);
    }

    public void reloadMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.getDataFolder(), MESSAGES_FILE_NAME);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defaultStream = this.getResource(MESSAGES_FILE_NAME);
        if (defaultStream != null) {
            this.messagesConfig.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream)));
        }
    }

    public FileConfiguration getMessagesConfig() {
        if (this.messagesConfig == null) {
            this.reloadMessages();
        }
        return this.messagesConfig;
    }

    public void saveDefaultMessages() {
        if (this.messagesFile == null) {
            this.messagesFile = new File(this.getDataFolder(), MESSAGES_FILE_NAME);
        }
        if (!this.messagesFile.exists()) {
            this.saveResource(MESSAGES_FILE_NAME, false);
        }
    }

    private String formatColors(String text) {
        Matcher matcher = HEX_PATTERN.matcher(text);
        while (matcher.find()) {
            String color = text.substring(matcher.start(), matcher.end());
            text = text.replace(color, ChatColor.of((String)color.substring(1, color.length() - 1)).toString());
            matcher = HEX_PATTERN.matcher(text);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static xDay getInstance() {
        return instance;
    }

    public static xDayAPI getApi() {
        return api;
    }
}

