/*
 * Decompiled with CFR 0.152.
 */
package de.gamedude.easyvillagertrade.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.gamedude.easyvillagertrade.core.EasyVillagerTradeBase;
import de.gamedude.easyvillagertrade.utils.TradeRequest;
import de.gamedude.easyvillagertrade.utils.TradingState;
import java.util.Arrays;
import joptsimple.internal.Strings;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;

public class EasyVillagerTradeCommand
implements ClientCommandRegistrationCallback {
    private final EasyVillagerTradeBase modBase;

    public EasyVillagerTradeCommand(EasyVillagerTradeBase modBase) {
        this.modBase = modBase;
    }

    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        String command_base = "evt";
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)command_base).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"select").then(ClientCommandManager.literal((String)"close").executes(this::executeSelectionClosest))).executes(this::executeSelection))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"search").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"maxPrice", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(context -> this.executeAddTradeRequest((CommandContext<FabricClientCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"maxPrice"), 1))).then(ClientCommandManager.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(context -> this.executeAddTradeRequest((CommandContext<FabricClientCommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"maxPrice"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, (class_5321)class_7924.field_41265)).executes(this::executeRemoveTradeRequest)))).then(ClientCommandManager.literal((String)"list").executes(this::executeListTradeRequest)))).then(ClientCommandManager.literal((String)"execute").executes(this::executeVillagerTrade))).then(ClientCommandManager.literal((String)"stop").executes(ctx -> {
            this.modBase.setState(TradingState.INACTIVE);
            return 1;
        }))).executes(ctx -> {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"evt.command.basic_usage"));
            return 1;
        }));
    }

    public int executeAddTradeRequest(CommandContext<FabricClientCommandSource> context, int maxPrice, int level) {
        class_6880.class_6883 reference = (class_6880.class_6883)context.getArgument("enchantment", class_6880.class_6883.class);
        if (!reference.method_40237().method_31163(class_7924.field_41265)) {
            return 0;
        }
        class_1887 enchantment = (class_1887)reference.comp_349();
        TradeRequest tradeRequest = this.modBase.getTradeRequestInputHandler().parseCommandInput(enchantment, level, maxPrice);
        this.modBase.getTradeRequestContainer().addTradeRequest(tradeRequest);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"evt.command.add", (Object[])new Object[]{"\u00a7e" + class_1887.method_8179(tradeRequest.enchantment(), (int)tradeRequest.level()).getString(), "\u00a7a" + tradeRequest.maxPrice()}));
        return 1;
    }

    public int executeRemoveTradeRequest(CommandContext<FabricClientCommandSource> context) {
        class_6880.class_6883 reference = (class_6880.class_6883)context.getArgument("enchantment", class_6880.class_6883.class);
        Object object = reference.comp_349();
        if (!(object instanceof class_1887)) {
            return 0;
        }
        class_1887 enchantment = (class_1887)object;
        class_6880.class_6883 enchantmentRegistryEntry = reference;
        this.modBase.getTradeRequestContainer().removeTradeRequestByEnchantment((class_6880<class_1887>)enchantmentRegistryEntry);
        boolean multipleLevels = enchantment.method_8183() == 1;
        String[] parts = class_1887.method_8179((class_6880)enchantmentRegistryEntry, (int)1).getString().split(" ");
        String name = Strings.join((String[])(multipleLevels ? parts : Arrays.copyOf(parts, parts.length - 1)), (String)" ");
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"evt.command.remove", (Object[])new Object[]{"\u00a7e" + StringUtils.capitalize((String)name)}));
        return 1;
    }

    public int executeListTradeRequest(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"evt.command.list.head"));
        this.modBase.getTradeRequestContainer().getTradeRequests().forEach(offer -> ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"evt.command.list.body", (Object[])new Object[]{"\u00a7e" + class_1887.method_8179(offer.enchantment(), (int)offer.level()).getString(), "\u00a7a" + offer.maxPrice()})));
        return 1;
    }

    public int executeSelection(CommandContext<FabricClientCommandSource> context) {
        this.modBase.setState(TradingState.MODE_SELECTION);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"evt.command.selecting"));
        return 1;
    }

    public int executeSelectionClosest(CommandContext<FabricClientCommandSource> context) {
        class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        int x = this.modBase.getSelectionInterface().selectClosestToPlayer(player);
        switch (x) {
            case 1: {
                player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.select.fail_lectern"), false);
                break;
            }
            case 2: {
                player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.select.fail_villager"), false);
                break;
            }
            case 0: {
                player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.select.success"), false);
            }
        }
        return 1;
    }

    public int executeVillagerTrade(CommandContext<FabricClientCommandSource> context) {
        this.modBase.setState(TradingState.CHECK_OFFERS);
        if (this.modBase.getSelectionInterface().getVillager() == null || this.modBase.getSelectionInterface().getLecternPos() == null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"evt.command.not_selected"));
            return 1;
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"evt.command.execute"));
        this.modBase.handleInteractionWithVillager();
        return 1;
    }
}

