/*
 * Decompiled with CFR 0.152.
 */
package de.gamedude.easyvillagertrade.core;

import de.gamedude.easyvillagertrade.EasyVillagerTrade;
import de.gamedude.easyvillagertrade.core.SelectionInterface;
import de.gamedude.easyvillagertrade.core.TradeInterface;
import de.gamedude.easyvillagertrade.core.TradeRequestContainer;
import de.gamedude.easyvillagertrade.core.TradeRequestInputHandler;
import de.gamedude.easyvillagertrade.utils.TradeRequest;
import de.gamedude.easyvillagertrade.utils.TradingState;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2879;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9304;

public class EasyVillagerTradeBase {
    private TradingState state;
    private final TradeRequestContainer tradeRequestContainer;
    private final SelectionInterface selectionInterface;
    private final TradeRequestInputHandler tradeRequestInputHandler;
    private final TradeInterface tradeInterface;
    private final class_310 minecraftClient = class_310.method_1551();

    public EasyVillagerTradeBase() {
        this.tradeRequestContainer = new TradeRequestContainer();
        this.selectionInterface = new SelectionInterface(this);
        this.tradeRequestInputHandler = new TradeRequestInputHandler();
        this.tradeInterface = new TradeInterface(this);
        this.state = TradingState.INACTIVE;
    }

    public TradeRequestInputHandler getTradeRequestInputHandler() {
        return this.tradeRequestInputHandler;
    }

    public SelectionInterface getSelectionInterface() {
        return this.selectionInterface;
    }

    public TradeRequestContainer getTradeRequestContainer() {
        return this.tradeRequestContainer;
    }

    public void setState(TradingState state) {
        this.state = state;
    }

    public TradingState getState() {
        return this.state;
    }

    public void handle() {
        if (this.state == TradingState.INACTIVE) {
            return;
        }
        switch (this.state) {
            case BREAK_WORKSTATION: {
                this.handleBreak();
                break;
            }
            case PLACE_WORKSTATION: {
                this.handlePlacement();
                break;
            }
            case SELECT_TRADE: {
                this.tradeInterface.selectTrade();
                break;
            }
            case APPLY_TRADE: {
                this.tradeInterface.applyTrade();
                break;
            }
            case PICKUP_TRADE: {
                this.tradeInterface.pickupBook();
                break;
            }
            case WAIT_JOB_LOSS: {
                if (!this.selectionInterface.getVillager().method_7231().comp_3521().method_40230().orElse(class_3852.field_17062).equals(class_3852.field_17051)) break;
                this.setState(TradingState.PLACE_WORKSTATION);
            }
        }
    }

    private void handlePlacement() {
        class_746 player = this.minecraftClient.field_1724;
        class_2338 lecternPos = this.selectionInterface.getLecternPos();
        if (player.method_6079().equals(class_1799.field_8037)) {
            player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.lectern_non"), false);
            this.setState(TradingState.INACTIVE);
            return;
        }
        class_3965 hitResult = new class_3965(lecternPos.method_61082().method_1031(0.0, 1.0, 0.0), class_2350.field_11036, lecternPos, false);
        this.minecraftClient.field_1761.method_2896(player, class_1268.field_5810, hitResult);
        player.method_6104(class_1268.field_5810);
        this.setState(TradingState.WAIT_PROFESSION);
    }

    private void handleBreak() {
        class_638 world = this.minecraftClient.field_1687;
        class_746 player = this.minecraftClient.field_1724;
        class_2338 blockPos = this.getSelectionInterface().getLecternPos();
        if (world == null || player == null) {
            return;
        }
        int preventionValue = EasyVillagerTrade.CONFIG.getProperty("preventAxeBreakingValue").getAsInt();
        class_1799 tool = player.method_6047();
        if (preventionValue != -1 && tool.method_7936() - tool.method_7919() <= preventionValue) {
            player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.axe_durability"), false);
            this.setState(TradingState.INACTIVE);
            return;
        }
        if (blockPos == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"evt.logic.pos_not_set"), false);
            this.setState(TradingState.INACTIVE);
            return;
        }
        if (world.method_8320(this.getSelectionInterface().getLecternPos()).method_26204() == class_2246.field_16330) {
            this.minecraftClient.field_1761.method_2902(this.getSelectionInterface().getLecternPos(), class_2350.field_11036);
            player.method_23667(class_1268.field_5808, true);
            player.field_3944.method_52787((class_2596)new class_2879(class_1268.field_5808));
        } else {
            this.state = TradingState.WAIT_JOB_LOSS;
        }
    }

    public void checkVillagerOffers(class_1916 tradeOffers) {
        class_1914 bookOffer = null;
        for (class_1914 offers : tradeOffers) {
            if (offers.method_8250().method_7909() != class_1802.field_8598) continue;
            bookOffer = offers;
            break;
        }
        if (bookOffer == null) {
            this.setState(TradingState.BREAK_WORKSTATION);
            return;
        }
        class_9304 enchantments = class_1890.method_57532((class_1799)bookOffer.method_8250());
        class_6880 bookEnchantment = (class_6880)enchantments.method_57534().iterator().next();
        int level = enchantments.method_57536(bookEnchantment);
        TradeRequest offer = new TradeRequest((class_6880<class_1887>)bookEnchantment, level, bookOffer.method_19272().method_7947());
        if (EasyVillagerTrade.CONFIG.getProperty("debugEnchantments").getAsBoolean()) {
            this.minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"evt.logic.trade.debug", (Object[])new Object[]{"\u00a7a" + offer.maxPrice(), "\u00a7e" + class_1887.method_8179((class_6880)bookEnchantment, (int)level).getString()}), false);
        }
        if (this.tradeRequestContainer.matchesAny(offer)) {
            this.minecraftClient.field_1724.method_7353((class_2561)class_2561.method_43469((String)"evt.logic.trade_found", (Object[])new Object[]{"\u00a7e" + class_1887.method_8179((class_6880)bookEnchantment, (int)level).getString(), "\u00a7a" + offer.maxPrice()}), false);
            this.minecraftClient.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_26942, (float)1.0f));
            this.tradeRequestContainer.removeTradeRequestByEnchantment((class_6880<class_1887>)bookEnchantment);
            this.tradeInterface.setTradeSlotID(tradeOffers.indexOf((Object)bookOffer));
            this.setState(TradingState.SELECT_TRADE);
        } else {
            this.setState(TradingState.BREAK_WORKSTATION);
        }
    }

    public void handleInteractionWithVillager() {
        this.minecraftClient.field_1761.method_2905((class_1657)class_310.method_1551().field_1724, (class_1297)this.selectionInterface.getVillager(), class_1268.field_5808);
    }
}

