/*
 * Decompiled with CFR 0.152.
 */
package de.gamedude.easyvillagertrade.screen.widget;

import de.gamedude.easyvillagertrade.EasyVillagerTrade;
import de.gamedude.easyvillagertrade.core.EasyVillagerTradeBase;
import de.gamedude.easyvillagertrade.utils.TradeRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_9848;

public class TradeRequestListWidget
extends class_362
implements class_4068,
class_6379 {
    private static final int ENTRY_HEIGHT = 32;
    private static int ENTRIES_PER_PAGE;
    private double scrollAmount;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final List<TradeRequestEntry> children;
    private final EasyVillagerTradeBase modBase;

    public TradeRequestListWidget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.children = new ArrayList<TradeRequestEntry>();
        this.modBase = EasyVillagerTrade.getModBase();
    }

    public int getEntryCount() {
        return this.children.size();
    }

    public TradeRequestEntry getEntry(int index) {
        return this.children.get(index);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        ENTRIES_PER_PAGE = (int)Math.ceil((float)(this.height - this.y + 5) / 37.0f - 1.0f);
        if (ENTRIES_PER_PAGE == 0) {
            return;
        }
        this.renderBackground(context);
        for (int index = 0; index < Math.min(this.getEntryCount(), ENTRIES_PER_PAGE); ++index) {
            this.getEntry(index + this.getOffset()).render(context, index, this.x, this.y + 1, this.width);
        }
    }

    private int getOffset() {
        int maxScroll = this.getMaxScroll();
        int currentScroll = (int)Math.abs(this.scrollAmount);
        return Math.min(maxScroll > 0 ? (int)Math.ceil((float)maxScroll / 37.0f) : 0, (int)Math.ceil((float)currentScroll / 37.0f));
    }

    protected int getMaxPosition() {
        return this.getEntryCount() * 37 - 5;
    }

    public int getMaxScroll() {
        return this.getMaxPosition() - ENTRIES_PER_PAGE * 37;
    }

    public List<TradeRequestEntry> method_25396() {
        return this.children;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        this.scrollAmount = class_3532.method_15350((double)(this.scrollAmount - vertical * 37.0), (double)0.0, (double)this.getMaxScroll());
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return (double)this.x <= mouseX && mouseX <= (double)(this.x + this.width) && (double)this.y <= mouseY && mouseY <= (double)this.height;
    }

    private void renderBackground(class_332 context) {
        context.method_25294(this.x - 1, this.y, this.x + this.width + 1, this.y + 1, -1);
        context.method_25294(this.x - 2, this.height, this.x + this.width + 2, this.height + 1, -1);
        context.method_25294(this.x - 2, this.y, this.x - 1, this.height, -1);
        context.method_25294(this.x + this.width + 1, this.y, this.x + this.width + 2, this.height, -1);
    }

    public void addEntry(TradeRequest entry) {
        this.children.add(new TradeRequestEntry(entry));
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean bl = super.method_25402(click, doubled);
        Optional element = this.method_19355(click.comp_4798(), click.comp_4799());
        if (element.isEmpty()) {
            return bl;
        }
        TradeRequestEntry tradeRequestEntry = (TradeRequestEntry)element.get();
        int entriesSkipped = Math.ceilDiv((int)this.scrollAmount, 37);
        if (this.children.indexOf(tradeRequestEntry) == 0 && this.children.size() > ENTRIES_PER_PAGE) {
            this.scrollAmount -= 37.0;
            tradeRequestEntry = this.children.get(entriesSkipped);
        }
        this.children.remove(tradeRequestEntry);
        this.modBase.getTradeRequestContainer().removeTradeRequest(tradeRequestEntry.tradeRequest);
        return bl;
    }

    public void method_37020(class_6382 builder) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public static class TradeRequestEntry
    implements class_364 {
        private static final class_2960 EMERALD_TEXTURE = class_2960.method_60654((String)"textures/item/emerald.png");
        private static final class_2960 ENCHANTED_BOOK_TEXTURE = class_2960.method_60654((String)"textures/item/enchanted_book.png");
        private final class_327 textRenderer;
        public final TradeRequest tradeRequest;
        private int x;
        private int y1;
        private int x2;
        private int y2;

        public TradeRequestEntry(TradeRequest request) {
            this.textRenderer = class_310.method_1551().field_1772;
            this.tradeRequest = request;
        }

        private void render(class_332 context, int index, int x, int y, int entryWidth) {
            this.x = x;
            this.y1 = y + index * 32 + 5 * index;
            this.x2 = x + entryWidth;
            this.y2 = y + 32 * (index + 1) + 5 * index;
            context.method_25294(x, this.y1, this.x2, this.y2, class_9848.method_61324((int)240, (int)7, (int)7, (int)7));
            context.method_25290(class_10799.field_56883, ENCHANTED_BOOK_TEXTURE, x, this.y1, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_25290(class_10799.field_56883, EMERALD_TEXTURE, x, this.y1 + 16, 0.0f, 0.0f, 16, 16, 16, 16);
            context.method_51439(this.textRenderer, class_1887.method_8179(this.tradeRequest.enchantment(), (int)this.tradeRequest.level()), x + 20, this.y1 + 4, -2039584, false);
            context.method_51439(this.textRenderer, class_2561.method_30163((String)("\u00a7e" + this.tradeRequest.maxPrice())), x + 20, this.y1 + 20, -2039584, false);
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return (double)this.x <= mouseX && mouseX <= (double)this.x2 && (double)this.y1 <= mouseY && mouseY <= (double)this.y2;
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return false;
        }
    }
}

