/*
 * Decompiled with CFR 0.152.
 */
package de.gamedude.easyvillagertrade.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_310;

public class Config {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, JsonElement> properties = new HashMap<String, JsonElement>();
    private final File file;

    public Config(String fileName) {
        this.file = this.getOrCreateFile(fileName);
        if (this.file.length() == 0L) {
            this.loadDefaultProperties();
            this.savePropertiesToFile();
        }
        this.loadDefaultProperties();
        this.loadPropertiesFromFile();
        Runtime.getRuntime().addShutdownHook(new Thread(this::savePropertiesToFile));
    }

    private void loadPropertiesFromFile() {
        try (FileReader fileReader = new FileReader(this.file);){
            JsonObject jsonObject = (JsonObject)this.gson.fromJson((Reader)fileReader, JsonObject.class);
            for (Map.Entry entry : jsonObject.entrySet()) {
                this.properties.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (IOException e) {
            LogUtils.getLogger().error(e.getMessage());
        }
    }

    public void savePropertiesToFile() {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.properties.entrySet()) {
            jsonObject.add(entry.getKey(), entry.getValue());
        }
        String json = this.gson.toJson((JsonElement)jsonObject);
        this.writeToFile(json);
    }

    public JsonElement getProperty(String key) {
        return this.properties.get(key);
    }

    public void addProperty(String key, Object obj) {
        JsonElement element = this.gson.toJsonTree(obj);
        this.properties.put(key, element);
    }

    private File getOrCreateFile(String fileName) {
        File file = new File(class_310.method_1551().field_1697, "config/" + fileName + ".json");
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return file;
    }

    private void writeToFile(String content) {
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(content);
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Could not write to file: ");
            LogUtils.getLogger().error(e.getMessage());
        }
    }

    private void loadDefaultProperties() {
        this.addProperty("preventAxeBreakingValue", 10);
        this.addProperty("debugEnchantments", false);
    }
}

