/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.autoclicker;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import it.unimi.dsi.fastutil.Pair;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.mikey.autoclicker.Config;
import pro.mikey.autoclicker.Holding;
import pro.mikey.autoclicker.Language;
import pro.mikey.autoclicker.OptionsScreen;

public class AutoClicker {
    public static final String MOD_ID = "autoclicker";
    public static final Logger LOGGER = LogManager.getLogger((String)"autoclicker");
    private static final KeyMapping.Category KEYBIND_CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"autoclicker", (String)"keybinding-title"));
    public static final KeyMapping openConfig = new KeyMapping("keybinding.open-gui", 79, KEYBIND_CATEGORY);
    public static final KeyMapping toggleHolding = new KeyMapping("keybinding.toggle-hold", 73, KEYBIND_CATEGORY);
    private static final Supplier<Pair<Path, Path>> CONFIG_PATHS = Suppliers.memoize(() -> {
        Path configDir = Paths.get(Minecraft.getInstance().gameDirectory.getPath() + "/config", new String[0]);
        Path configFile = Paths.get(String.valueOf(configDir) + "/auto-clicker-fabric.json", new String[0]);
        return Pair.of((Object)configDir, (Object)configFile);
    });
    public static Holding.AttackHolding leftHolding;
    public static Holding rightHolding;
    public static Holding jumpHolding;
    public static Config.HudConfig hudConfig;
    private static AutoClicker INSTANCE;
    private boolean isActive = false;
    private Config config = new Config(new Config.LeftMouseConfig(false, false, 0, false, false, false), new Config.RightMouseConfig(false, false, 0), new Config.JumpConfig(false, false, 0), new Config.HudConfig(true, "top-left"));

    public AutoClicker() {
        INSTANCE = this;
    }

    public static AutoClicker getInstance() {
        return INSTANCE;
    }

    public void onInitialize() {
        LOGGER.info("Auto Clicker Initialised");
    }

    public void clientReady(Minecraft client) {
        Pair<Path, Path> configPaths = CONFIG_PATHS.get();
        if (!Files.exists((Path)configPaths.value(), new LinkOption[0])) {
            try {
                Files.createDirectories((Path)configPaths.key(), new FileAttribute[0]);
                Files.createFile((Path)configPaths.value(), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.saveConfig();
        } else {
            try {
                FileReader json = new FileReader(((Path)configPaths.value()).toFile());
                Config config = (Config)new Gson().fromJson((Reader)json, Config.class);
                json.close();
                if (config != null && config.getHudConfig() != null) {
                    this.config = config;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveConfig();
            }
        }
        leftHolding = new Holding.AttackHolding(client.options.keyAttack, this.config.getLeftClick());
        rightHolding = new Holding(client.options.keyUse, this.config.getRightClick());
        jumpHolding = new Holding(client.options.keyJump, this.config.getJump());
        hudConfig = this.config.getHudConfig();
    }

    public void saveConfig() {
        Pair<Path, Path> configPaths = CONFIG_PATHS.get();
        try {
            FileWriter writer = new FileWriter(((Path)configPaths.value()).toFile());
            new Gson().toJson((Object)this.config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void renderGameOverlayEvent(GuiGraphics context, DeltaTracker delta) {
        int x;
        int y;
        Component text;
        if (!((leftHolding.isActive() || rightHolding.isActive() || jumpHolding.isActive()) && this.isActive && this.config.getHudConfig().isEnabled())) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (leftHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(I18n.get((String)leftHolding.getKey().getName(), (Object[])new Object[0]));
            y = this.getHudY() + 0;
            x = this.getHudX(text);
            context.drawString(client.font, text.getVisualOrderText(), x, y, -1);
        }
        if (rightHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(I18n.get((String)rightHolding.getKey().getName(), (Object[])new Object[0]));
            y = this.getHudY() + 15;
            x = this.getHudX(text);
            context.drawString(client.font, text.getVisualOrderText(), x, y, -1);
        }
        if (jumpHolding.isActive()) {
            text = Language.HUD_HOLDING.getText(I18n.get((String)jumpHolding.getKey().getName(), (Object[])new Object[0]));
            y = this.getHudY() + 30;
            x = this.getHudX(text);
            context.drawString(client.font, text.getVisualOrderText(), x, y, -1);
        }
    }

    public int getHudX(Component text) {
        String location;
        Minecraft client = Minecraft.getInstance();
        return switch (location = this.config.getHudConfig().getLocation()) {
            case "top-left", "bottom-left" -> 10;
            case "top-right", "bottom-right" -> Minecraft.getInstance().getWindow().getGuiScaledWidth() - 10 - client.font.width((FormattedText)text);
            default -> 10;
        };
    }

    public int getHudY() {
        String location;
        return switch (location = this.config.getHudConfig().getLocation()) {
            case "top-left", "top-right" -> 10;
            case "bottom-left", "bottom-right" -> Minecraft.getInstance().getWindow().getGuiScaledHeight() - 50;
            default -> 10;
        };
    }

    public void clientTickEvent(Minecraft mc) {
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (!mc.player.isAlive()) {
            this.isActive = false;
        }
        if (this.isActive) {
            if (leftHolding.isActive()) {
                this.handleActiveHolding(mc, leftHolding);
            }
            if (rightHolding.isActive()) {
                this.handleActiveHolding(mc, rightHolding);
            }
            if (jumpHolding.isActive()) {
                this.handleActiveHolding(mc, jumpHolding);
            }
        }
        this.keyInputEvent(mc);
    }

    private void handleActiveHolding(Minecraft mc, Holding key) {
        assert (mc.player != null);
        if (!key.isActive()) {
            return;
        }
        if (key.isSpamming()) {
            if (key.getSpeed() > 0) {
                if (key.getTimeout() <= 1) {
                    if (key.getTimeout() <= 0) {
                        key.resetTimeout();
                    }
                    key.getKey().setDown(key.getTimeout() == 1);
                    if (key.getKey().isDown()) {
                        this.attemptMobAttack(mc, key);
                    }
                }
                key.decreaseTimeout();
            } else {
                key.getKey().setDown(!key.getKey().isDown());
                if (key.getKey().isDown()) {
                    this.attemptMobAttack(mc, key);
                }
            }
            return;
        }
        if (key.isRespectCooldown()) {
            if (key instanceof Holding.AttackHolding && ((Holding.AttackHolding)key).isMobMode() && !this.isPlayerLookingAtMob(mc)) {
                if (key.getKey().isDown()) {
                    key.getKey().setDown(false);
                }
                return;
            }
            if (mc.player.getAttackStrengthScale(0.0f) == 1.0f) {
                key.getKey().setDown(true);
                this.attemptMobAttack(mc, key);
            } else {
                key.getKey().setDown(false);
            }
        } else {
            key.getKey().setDown(true);
        }
    }

    private void attemptMobAttack(Minecraft mc, Holding key) {
        if (key.getKey() != leftHolding.getKey()) {
            return;
        }
        HitResult rayTrace = mc.hitResult;
        if (!(!(rayTrace instanceof EntityHitResult) || mc.gameMode == null || this.config.getLeftClick().isRespectShield() && this.isShielding(mc.player))) {
            mc.gameMode.attack((Player)mc.player, ((EntityHitResult)rayTrace).getEntity());
            if (mc.player != null) {
                mc.player.swing(InteractionHand.MAIN_HAND);
            }
        }
    }

    private boolean isShielding(LocalPlayer player) {
        if (player.isUsingItem()) {
            return player.getUseItem().getItem() instanceof ShieldItem;
        }
        return false;
    }

    private boolean isPlayerLookingAtMob(Minecraft mc) {
        LivingEntity livingEntity;
        Entity entity;
        HitResult rayTrace = mc.hitResult;
        return rayTrace instanceof EntityHitResult && (entity = ((EntityHitResult)rayTrace).getEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive() && livingEntity.isAttackable();
    }

    private void keyInputEvent(Minecraft mc) {
        assert (mc.player != null);
        while (toggleHolding.consumeClick()) {
            this.isActive = !this.isActive;
            mc.player.displayClientMessage((Component)(this.isActive ? Language.MSG_HOLDING_KEYS : Language.MSG_RELEASED_KEYS).getText().withStyle(this.isActive ? ChatFormatting.GREEN : ChatFormatting.RED), true);
            if (this.isActive) continue;
            if (leftHolding.isActive()) {
                leftHolding.getKey().setDown(false);
            }
            if (rightHolding.isActive()) {
                rightHolding.getKey().setDown(false);
            }
            if (!jumpHolding.isActive()) continue;
            jumpHolding.getKey().setDown(false);
        }
        while (openConfig.consumeClick()) {
            mc.setScreen((Screen)this.getConfigScreen());
        }
    }

    public OptionsScreen getConfigScreen() {
        return new OptionsScreen();
    }
}

